/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.format.AutodetectGeneralFormatStyle;
import org.openrewrite.java.format.BlankLinesVisitor;
import org.openrewrite.java.format.MinimumViableSpacingVisitor;
import org.openrewrite.java.format.NormalizeFormatVisitor;
import org.openrewrite.java.format.NormalizeLineBreaksVisitor;
import org.openrewrite.java.format.NormalizeTabsOrSpacesVisitor;
import org.openrewrite.java.format.RemoveTrailingWhitespaceVisitor;
import org.openrewrite.java.format.SpacesVisitor;
import org.openrewrite.java.format.TabsAndIndentsVisitor;
import org.openrewrite.java.format.WrappingAndBracesVisitor;
import org.openrewrite.java.style.BlankLinesStyle;
import org.openrewrite.java.style.EmptyForInitializerPadStyle;
import org.openrewrite.java.style.EmptyForIteratorPadStyle;
import org.openrewrite.java.style.IntelliJ;
import org.openrewrite.java.style.SpacesStyle;
import org.openrewrite.java.style.TabsAndIndentsStyle;
import org.openrewrite.java.style.WrappingAndBracesStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.style.GeneralFormatStyle;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.style.Style;

public class AutoFormatVisitor<P>
extends JavaIsoVisitor<P> {
    private final @Nullable Tree stopAfter;
    private final List<NamedStyles> styles;

    public AutoFormatVisitor() {
        this(null, new NamedStyles[0]);
    }

    public AutoFormatVisitor(@Nullable Tree stopAfter, NamedStyles ... style) {
        this.stopAfter = stopAfter;
        this.styles = Arrays.stream(style).collect(Collectors.toList());
    }

    @Override
    public boolean isAcceptable(SourceFile sourceFile, P p) {
        return sourceFile instanceof J.CompilationUnit;
    }

    public J visit(@Nullable Tree tree, P p, Cursor cursor) {
        JavaSourceFile cu;
        JavaSourceFile javaSourceFile = cu = tree instanceof JavaSourceFile ? (JavaSourceFile)tree : (JavaSourceFile)cursor.firstEnclosingOrThrow(JavaSourceFile.class);
        if (tree == null) {
            tree = (Tree)cursor.getValue();
        }
        J t = (J)new NormalizeFormatVisitor(this.stopAfter).visitNonNull(tree, p, cursor.fork());
        t = (J)new MinimumViableSpacingVisitor(this.stopAfter).visitNonNull(t, p, cursor.fork());
        t = (J)new BlankLinesVisitor(this.getStyle(BlankLinesStyle.class, cu, IntelliJ::blankLines), this.stopAfter).visitNonNull(t, p, cursor.fork());
        t = (J)new WrappingAndBracesVisitor(this.getStyle(WrappingAndBracesStyle.class, cu, IntelliJ::wrappingAndBraces), this.stopAfter).visitNonNull(t, p, cursor.fork());
        SpacesStyle spacesStyle = this.getStyle(SpacesStyle.class, cu, IntelliJ::spaces);
        TabsAndIndentsStyle tabsAndIndentsStyle = this.getStyle(TabsAndIndentsStyle.class, cu, IntelliJ::tabsAndIndents);
        t = (J)new SpacesVisitor(spacesStyle, this.getStyle(EmptyForInitializerPadStyle.class, cu), this.getStyle(EmptyForIteratorPadStyle.class, cu), this.stopAfter).visitNonNull(t, p, cursor.fork());
        t = (J)new NormalizeTabsOrSpacesVisitor(tabsAndIndentsStyle, this.stopAfter).visitNonNull(t, p, cursor.fork());
        t = (J)new TabsAndIndentsVisitor(tabsAndIndentsStyle, spacesStyle, this.stopAfter).visitNonNull(t, p, cursor.fork());
        t = (J)new NormalizeLineBreaksVisitor(this.getStyle(GeneralFormatStyle.class, cu, () -> AutodetectGeneralFormatStyle.autodetectGeneralFormatStyle(cu)), this.stopAfter).visitNonNull(t, p, cursor.fork());
        return (J)new RemoveTrailingWhitespaceVisitor(this.stopAfter).visitNonNull(t, p, cursor.fork());
    }

    public J visit(@Nullable Tree tree, P p) {
        if (tree instanceof JavaSourceFile) {
            JavaSourceFile cu = (JavaSourceFile)Objects.requireNonNull(tree);
            if (!(cu instanceof J.CompilationUnit)) {
                return cu;
            }
            JavaSourceFile t = (JavaSourceFile)new RemoveTrailingWhitespaceVisitor(this.stopAfter).visitNonNull(cu, p);
            t = (JavaSourceFile)new BlankLinesVisitor(this.getStyle(BlankLinesStyle.class, cu, IntelliJ::blankLines), this.stopAfter).visitNonNull(t, p);
            SpacesStyle spacesStyle = this.getStyle(SpacesStyle.class, cu, IntelliJ::spaces);
            TabsAndIndentsStyle tabsAndIndentsStyle = this.getStyle(TabsAndIndentsStyle.class, cu, IntelliJ::tabsAndIndents);
            t = (JavaSourceFile)new SpacesVisitor(spacesStyle, this.getStyle(EmptyForInitializerPadStyle.class, cu), this.getStyle(EmptyForIteratorPadStyle.class, cu), this.stopAfter).visitNonNull(t, p);
            t = (JavaSourceFile)new WrappingAndBracesVisitor(this.getStyle(WrappingAndBracesStyle.class, cu, IntelliJ::wrappingAndBraces), this.stopAfter).visitNonNull(t, p);
            t = (JavaSourceFile)new NormalizeTabsOrSpacesVisitor(tabsAndIndentsStyle, this.stopAfter).visitNonNull(t, p);
            return (J)new TabsAndIndentsVisitor(tabsAndIndentsStyle, spacesStyle, this.stopAfter).visitNonNull(t, p);
        }
        return (J)tree;
    }

    private <S extends Style> @Nullable S getStyle(Class<S> styleClass, JavaSourceFile sourceFile) {
        Style style = NamedStyles.merge(styleClass, this.styles);
        if (style != null) {
            return (S)style;
        }
        return (S)Style.from(styleClass, (SourceFile)sourceFile);
    }

    private <S extends Style> S getStyle(Class<S> styleClass, JavaSourceFile sourceFile, Supplier<S> defaultStyle) {
        Style style = NamedStyles.merge(styleClass, this.styles);
        if (style != null) {
            return (S)style;
        }
        return (S)Style.from(styleClass, (SourceFile)sourceFile, defaultStyle);
    }
}

