/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.TypeMatcher;
import org.openrewrite.java.search.DeclaresMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

public final class RemoveMethodThrows
extends Recipe {
    @Option(displayName="Method pattern", description="A [method pattern](https://docs.openrewrite.org/reference/method-patterns) is used to find matching method invocations. For example, to find all method invocations in the Guava library, use the pattern: `com.google.common..*#*(..)`.<br/><br/>The pattern format is `<PACKAGE>#<METHOD_NAME>(<ARGS>)`. <br/><br/>`..*` includes all subpackages of `com.google.common`. <br/>`*(..)` matches any method name with any number of arguments. <br/><br/>For more specific queries, like Guava's `ImmutableMap`, use `com.google.common.collect.ImmutableMap#*(..)` to narrow down the results.", example="java.util.List add(..)")
    private final String methodPattern;
    @Option(displayName="Match on overrides", description="When enabled, match methods that are overrides of the method pattern. Default is true.", required=false)
    private final @Nullable Boolean matchOverrides;
    @Option(displayName="Exception type pattern", description="A type pattern that is used to find matching exception to remove. Use `*` to match all.", example="java.io.IOException")
    private final String exceptionTypePattern;

    public String getDisplayName() {
        return "Remove elements from a method declaration `throws` clause";
    }

    public String getDescription() {
        return "Remove specific, or all exceptions from a method declaration `throws` clause.";
    }

    public Validated<Object> validate() {
        return super.validate().and(MethodMatcher.validate(this.methodPattern));
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final MethodMatcher methodMatcher = new MethodMatcher(this.methodPattern, this.matchOverrides != null ? this.matchOverrides : true);
        final TypeMatcher typeMatcher = new TypeMatcher(this.exceptionTypePattern, true);
        return Preconditions.check(new DeclaresMethod(methodMatcher), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                J.ClassDeclaration cd;
                J m = super.visitMethodDeclaration(method, ctx);
                if (methodMatcher.matches((J.MethodDeclaration)m, cd = (J.ClassDeclaration)this.getCursor().firstEnclosingOrThrow(J.ClassDeclaration.class)) && ((J.MethodDeclaration)m).getThrows() != null) {
                    return ((J.MethodDeclaration)m).withThrows(ListUtils.map(((J.MethodDeclaration)m).getThrows(), nt -> {
                        if (typeMatcher.matches(nt.getType())) {
                            this.maybeRemoveImport(nt.getType().toString());
                            return null;
                        }
                        return nt;
                    }));
                }
                return m;
            }

            @Override
            public @Nullable JavaType visitType(@Nullable JavaType javaType, ExecutionContext ctx) {
                JavaType jt = super.visitType(javaType, ctx);
                if (jt instanceof JavaType.Method && methodMatcher.matches((JavaType.Method)jt)) {
                    JavaType.Method mt = (JavaType.Method)jt;
                    return mt.withThrownExceptions(ListUtils.filter(mt.getThrownExceptions(), te -> !typeMatcher.matches((JavaType)te)));
                }
                return jt;
            }
        });
    }

    @Generated
    public RemoveMethodThrows(String methodPattern, @Nullable Boolean matchOverrides, String exceptionTypePattern) {
        this.methodPattern = methodPattern;
        this.matchOverrides = matchOverrides;
        this.exceptionTypePattern = exceptionTypePattern;
    }

    @Generated
    public String getMethodPattern() {
        return this.methodPattern;
    }

    @Generated
    public @Nullable Boolean getMatchOverrides() {
        return this.matchOverrides;
    }

    @Generated
    public String getExceptionTypePattern() {
        return this.exceptionTypePattern;
    }

    @NonNull
    @Generated
    public String toString() {
        return "RemoveMethodThrows(methodPattern=" + this.getMethodPattern() + ", matchOverrides=" + this.getMatchOverrides() + ", exceptionTypePattern=" + this.getExceptionTypePattern() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveMethodThrows)) {
            return false;
        }
        RemoveMethodThrows other = (RemoveMethodThrows)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$matchOverrides = this.getMatchOverrides();
        Boolean other$matchOverrides = other.getMatchOverrides();
        if (this$matchOverrides == null ? other$matchOverrides != null : !((Object)this$matchOverrides).equals(other$matchOverrides)) {
            return false;
        }
        String this$methodPattern = this.getMethodPattern();
        String other$methodPattern = other.getMethodPattern();
        if (this$methodPattern == null ? other$methodPattern != null : !this$methodPattern.equals(other$methodPattern)) {
            return false;
        }
        String this$exceptionTypePattern = this.getExceptionTypePattern();
        String other$exceptionTypePattern = other.getExceptionTypePattern();
        return !(this$exceptionTypePattern == null ? other$exceptionTypePattern != null : !this$exceptionTypePattern.equals(other$exceptionTypePattern));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof RemoveMethodThrows;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $matchOverrides = this.getMatchOverrides();
        result = result * 59 + ($matchOverrides == null ? 43 : ((Object)$matchOverrides).hashCode());
        String $methodPattern = this.getMethodPattern();
        result = result * 59 + ($methodPattern == null ? 43 : $methodPattern.hashCode());
        String $exceptionTypePattern = this.getExceptionTypePattern();
        result = result * 59 + ($exceptionTypePattern == null ? 43 : $exceptionTypePattern.hashCode());
        return result;
    }
}

