/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.marketplace;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Recipe;
import org.openrewrite.config.ClasspathScanningLoader;
import org.openrewrite.config.Environment;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.config.ResourceLoader;
import org.openrewrite.marketplace.RecipeBundle;
import org.openrewrite.marketplace.RecipeBundleReader;
import org.openrewrite.marketplace.RecipeClassLoader;
import org.openrewrite.marketplace.RecipeClassLoaderFactory;
import org.openrewrite.marketplace.RecipeListing;
import org.openrewrite.marketplace.RecipeMarketplace;
import org.openrewrite.marketplace.RecipeMarketplaceReader;
import org.openrewrite.maven.tree.GroupArtifactVersion;
import org.openrewrite.maven.tree.MavenResolutionResult;
import org.openrewrite.maven.tree.ResolvedDependency;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;
import org.openrewrite.maven.tree.Scope;
import org.openrewrite.maven.utilities.MavenArtifactDownloader;

public class MavenRecipeBundleReader
implements RecipeBundleReader {
    private static final Map<ResolvedGroupArtifactVersion, Lock> DEPENDENCY_LOCKS = new ConcurrentHashMap<ResolvedGroupArtifactVersion, Lock>();
    private final RecipeBundle bundle;
    private final MavenResolutionResult mrr;
    private final MavenArtifactDownloader downloader;
    private final RecipeClassLoaderFactory classLoaderFactory;
    private transient @Nullable Environment environment;
    transient @Nullable Path recipeJar;
    transient @Nullable List<Path> classpath;
    private transient @Nullable ClassLoader classLoader;

    /*
     * Enabled aggressive exception aggregation
     */
    public RecipeMarketplace read() {
        block17: {
            if (this.recipeJar == null) {
                for (ResolvedDependency resolvedDependency : this.mrr.getDependencies().get((Object)Scope.Runtime)) {
                    if (!this.isResolvedBundle(resolvedDependency)) continue;
                    this.recipeJar = this.downloader.downloadArtifact(resolvedDependency);
                    break;
                }
                if (this.recipeJar != null) {
                    try (JarFile jarFile = new JarFile(this.recipeJar.toFile());){
                        RecipeMarketplace recipeMarketplace;
                        block18: {
                            JarEntry entry = jarFile.getJarEntry("META-INF/rewrite/recipes.csv");
                            if (entry == null) break block17;
                            InputStream recipesCsv = jarFile.getInputStream(entry);
                            try {
                                RecipeMarketplace marketplace = new RecipeMarketplaceReader().fromCsv(recipesCsv);
                                for (RecipeListing recipe : marketplace.getAllRecipes()) {
                                    recipe.getBundle().setVersion(this.bundle.getVersion());
                                }
                                recipeMarketplace = marketplace;
                                if (recipesCsv == null) break block18;
                            }
                            catch (Throwable throwable) {
                                if (recipesCsv != null) {
                                    try {
                                        recipesCsv.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            recipesCsv.close();
                        }
                        return recipeMarketplace;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
        return this.marketplaceFromClasspathScan();
    }

    RecipeMarketplace marketplaceFromClasspathScan() {
        String[] ga = this.bundle.getPackageName().split(":");
        RecipeMarketplace marketplace = new RecipeMarketplace();
        List<Path> classpath = this.classpath();
        RecipeClassLoader classLoader = new RecipeClassLoader(Objects.requireNonNull(this.recipeJar), classpath);
        Environment env = Environment.builder().scanJar(Objects.requireNonNull(this.recipeJar).toAbsolutePath(), (Collection)classpath.stream().map(Path::toAbsolutePath).collect(Collectors.toList()), (ClassLoader)classLoader).build();
        Environment envWithCategories = this.environment();
        GroupArtifactVersion gav = new GroupArtifactVersion(ga[0], ga[1], this.bundle.getVersion());
        for (RecipeDescriptor descriptor : env.listRecipeDescriptors()) {
            marketplace.install(RecipeListing.fromDescriptor((RecipeDescriptor)descriptor, (RecipeBundle)new RecipeBundle("maven", gav.getGroupId() + ":" + gav.getArtifactId(), this.bundle.getRequestedVersion() == null ? gav.getVersion() : this.bundle.getRequestedVersion(), gav.getVersion(), null)), descriptor.inferCategoriesFromName(envWithCategories));
        }
        return marketplace;
    }

    public RecipeDescriptor describe(RecipeListing listing) {
        return this.environment().activateRecipes(new String[]{listing.getName()}).getDescriptor();
    }

    public Recipe prepare(RecipeListing listing, @Nullable Map<String, Object> options) {
        Recipe r = this.environment().activateRecipes(new String[]{listing.getName()});
        return r.withOptions(options);
    }

    private Environment environment() {
        if (this.environment == null) {
            this.environment = Environment.builder().load((ResourceLoader)new ClasspathScanningLoader(new Properties(), this.classLoader())).build();
        }
        return this.environment;
    }

    private ClassLoader classLoader() {
        if (this.classLoader == null) {
            List<Path> classpath = this.classpath();
            this.classLoader = this.classLoaderFactory.create(Objects.requireNonNull(this.recipeJar), classpath);
        }
        return this.classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Path> classpath() {
        if (this.classpath == null) {
            this.classpath = new ArrayList<Path>();
            for (ResolvedDependency resolvedDependency : this.mrr.getDependencies().get((Object)Scope.Runtime)) {
                if (this.recipeJar != null && this.isResolvedBundle(resolvedDependency)) {
                    this.classpath.add(this.recipeJar);
                    continue;
                }
                Lock lock = DEPENDENCY_LOCKS.computeIfAbsent(resolvedDependency.getGav(), g -> new ReentrantLock());
                lock.lock();
                try {
                    Path path = this.downloader.downloadArtifact(resolvedDependency);
                    if (path == null) {
                        throw new IllegalStateException("Unable to download dependency " + resolvedDependency.getGav());
                    }
                    if (resolvedDependency.isDirect()) {
                        this.recipeJar = path;
                    }
                    this.classpath.add(path);
                }
                finally {
                    lock.unlock();
                }
            }
        }
        return this.classpath;
    }

    private boolean isResolvedBundle(ResolvedDependency resolvedDependency) {
        return resolvedDependency.isDirect() && this.bundle.getPackageName().equals(resolvedDependency.getGroupId() + ":" + resolvedDependency.getArtifactId());
    }

    @Generated
    public MavenRecipeBundleReader(RecipeBundle bundle, MavenResolutionResult mrr, MavenArtifactDownloader downloader, RecipeClassLoaderFactory classLoaderFactory) {
        this.bundle = bundle;
        this.mrr = mrr;
        this.downloader = downloader;
        this.classLoaderFactory = classLoaderFactory;
    }

    @Generated
    public RecipeBundle getBundle() {
        return this.bundle;
    }
}

