/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import lombok.Generated;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.yaml.MergeYamlVisitor;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class MergeDuplicateSectionsVisitor<P>
extends YamlIsoVisitor<P> {
    private static final String NEW_ROOT_COMMENTS = "NEW_ROOT_COMMENTS";
    private final Yaml scope;

    @Override
    public Yaml.Document visitDocument(Yaml.Document document, P p) {
        Yaml d = super.visitDocument(document, (Object)p);
        String newRootComments = (String)this.getCursor().getMessage(NEW_ROOT_COMMENTS, (Object)"");
        if (!newRootComments.isEmpty()) {
            d = ((Yaml.Document)d).withPrefix(((Yaml.Document)d).getPrefix() + newRootComments);
        }
        return d;
    }

    @Override
    public Yaml.Mapping visitMapping(Yaml.Mapping mapping, P p) {
        Yaml m = super.visitMapping(mapping, (Object)p);
        if (((Yaml.Mapping)m).getEntries().size() < 2) {
            return m;
        }
        boolean changed = false;
        boolean isMappingUnderDocument = this.getCursor().getParentOrThrow().getValue() instanceof Yaml.Document;
        LinkedHashMap<String, Yaml.Mapping.Entry> newEntries = new LinkedHashMap<String, Yaml.Mapping.Entry>();
        for (Yaml.Mapping.Entry e : ((Yaml.Mapping)m).getEntries()) {
            String key = e.getKey().getValue();
            String prefix = e.getPrefix();
            if (MergeDuplicateSectionsVisitor.hasComments(prefix)) {
                changed = false;
                break;
            }
            if (newEntries.containsKey(key)) {
                Yaml.Mapping.Entry existingEntry = (Yaml.Mapping.Entry)newEntries.get(key);
                Yaml.Block value = e.getValue();
                Yaml mergedYaml = (Yaml)new MergeYamlVisitor(existingEntry.getValue(), value, false, null, false, null, null).visitNonNull(existingEntry.getValue(), p);
                newEntries.put(key, existingEntry.withValue((Yaml.Block)mergedYaml));
                changed = true;
                if (!isMappingUnderDocument || !StringUtils.isNotEmpty((String)prefix)) continue;
                prefix = prefix.startsWith("\n") ? prefix.substring(1) : prefix;
                String prev = (String)this.getCursor().getParentOrThrow().getMessage(NEW_ROOT_COMMENTS, (Object)"");
                this.getCursor().getParentOrThrow().putMessage(NEW_ROOT_COMMENTS, (Object)(prev + prefix));
                continue;
            }
            newEntries.put(key, e);
        }
        return changed ? ((Yaml.Mapping)m).withEntries(new ArrayList<Yaml.Mapping.Entry>(newEntries.values())) : m;
    }

    private static boolean hasComments(String prefix) {
        return StringUtils.isNotEmpty((String)prefix) && !prefix.matches("^(\\r\\n|\\n|\\r)+$");
    }

    @Generated
    public MergeDuplicateSectionsVisitor(Yaml scope) {
        this.scope = scope;
    }

    @Generated
    public Yaml getScope() {
        return this.scope;
    }

    @NonNull
    @Generated
    public String toString() {
        return "MergeDuplicateSectionsVisitor(scope=" + this.getScope() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MergeDuplicateSectionsVisitor)) {
            return false;
        }
        MergeDuplicateSectionsVisitor other = (MergeDuplicateSectionsVisitor)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Yaml this$scope = this.getScope();
        Yaml other$scope = other.getScope();
        return !(this$scope == null ? other$scope != null : !this$scope.equals(other$scope));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof MergeDuplicateSectionsVisitor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Yaml $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        return result;
    }
}

