/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jgit.api;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.openrewrite.jgit.api.GitCommand;
import org.openrewrite.jgit.api.errors.GitAPIException;
import org.openrewrite.jgit.api.errors.JGitInternalException;
import org.openrewrite.jgit.api.errors.NoHeadException;
import org.openrewrite.jgit.diff.DiffEntry;
import org.openrewrite.jgit.diff.DiffFormatter;
import org.openrewrite.jgit.dircache.DirCacheIterator;
import org.openrewrite.jgit.internal.JGitText;
import org.openrewrite.jgit.lib.NullProgressMonitor;
import org.openrewrite.jgit.lib.ObjectId;
import org.openrewrite.jgit.lib.ObjectReader;
import org.openrewrite.jgit.lib.ProgressMonitor;
import org.openrewrite.jgit.lib.Repository;
import org.openrewrite.jgit.treewalk.AbstractTreeIterator;
import org.openrewrite.jgit.treewalk.CanonicalTreeParser;
import org.openrewrite.jgit.treewalk.FileTreeIterator;
import org.openrewrite.jgit.treewalk.filter.TreeFilter;
import org.openrewrite.jgit.util.io.NullOutputStream;

public class DiffCommand
extends GitCommand<List<DiffEntry>> {
    private AbstractTreeIterator oldTree;
    private AbstractTreeIterator newTree;
    private boolean cached;
    private TreeFilter pathFilter = TreeFilter.ALL;
    private boolean showNameAndStatusOnly;
    private OutputStream out;
    private int contextLines = -1;
    private String sourcePrefix;
    private String destinationPrefix;
    private ProgressMonitor monitor = NullProgressMonitor.INSTANCE;

    protected DiffCommand(Repository repo) {
        super(repo);
    }

    private DiffFormatter getDiffFormatter() {
        return this.out != null && !this.showNameAndStatusOnly ? new DiffFormatter(new BufferedOutputStream(this.out)) : new DiffFormatter(NullOutputStream.INSTANCE);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<DiffEntry> call() throws GitAPIException {
        try (DiffFormatter diffFmt = this.getDiffFormatter();){
            List<DiffEntry> list;
            diffFmt.setRepository(this.repo);
            diffFmt.setProgressMonitor(this.monitor);
            if (this.cached) {
                if (this.oldTree == null) {
                    ObjectId head = this.repo.resolve("HEAD^{tree}");
                    if (head == null) {
                        throw new NoHeadException(JGitText.get().cannotReadTree);
                    }
                    CanonicalTreeParser p = new CanonicalTreeParser();
                    try (ObjectReader reader = this.repo.newObjectReader();){
                        p.reset(reader, head);
                    }
                    this.oldTree = p;
                }
                this.newTree = new DirCacheIterator(this.repo.readDirCache());
            } else {
                if (this.oldTree == null) {
                    this.oldTree = new DirCacheIterator(this.repo.readDirCache());
                }
                if (this.newTree == null) {
                    this.newTree = new FileTreeIterator(this.repo);
                }
            }
            diffFmt.setPathFilter(this.pathFilter);
            List<DiffEntry> result = diffFmt.scan(this.oldTree, this.newTree);
            if (this.showNameAndStatusOnly) {
                list = result;
                return list;
            }
            if (this.contextLines >= 0) {
                diffFmt.setContext(this.contextLines);
            }
            if (this.destinationPrefix != null) {
                diffFmt.setNewPrefix(this.destinationPrefix);
            }
            if (this.sourcePrefix != null) {
                diffFmt.setOldPrefix(this.sourcePrefix);
            }
            diffFmt.format(result);
            diffFmt.flush();
            list = result;
            return list;
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }

    public DiffCommand setCached(boolean cached) {
        this.cached = cached;
        return this;
    }

    public DiffCommand setPathFilter(TreeFilter pathFilter) {
        this.pathFilter = pathFilter;
        return this;
    }

    public DiffCommand setOldTree(AbstractTreeIterator oldTree) {
        this.oldTree = oldTree;
        return this;
    }

    public DiffCommand setNewTree(AbstractTreeIterator newTree) {
        this.newTree = newTree;
        return this;
    }

    public DiffCommand setShowNameAndStatusOnly(boolean showNameAndStatusOnly) {
        this.showNameAndStatusOnly = showNameAndStatusOnly;
        return this;
    }

    public DiffCommand setOutputStream(OutputStream out) {
        this.out = out;
        return this;
    }

    public DiffCommand setContextLines(int contextLines) {
        this.contextLines = contextLines;
        return this;
    }

    public DiffCommand setSourcePrefix(String sourcePrefix) {
        this.sourcePrefix = sourcePrefix;
        return this;
    }

    public DiffCommand setDestinationPrefix(String destinationPrefix) {
        this.destinationPrefix = destinationPrefix;
        return this;
    }

    public DiffCommand setProgressMonitor(ProgressMonitor monitor) {
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        this.monitor = monitor;
        return this;
    }
}

