/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import javax.vecmath.Point3d;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.formats.Gaussian03Format;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.periodictable.PeriodicTable;

public class Gaussian03Reader
extends DefaultChemObjectReader {
    private BufferedReader input;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(Gaussian03Reader.class);

    public Gaussian03Reader(Reader reader) {
        this.input = new BufferedReader(reader);
    }

    public Gaussian03Reader(InputStream input) {
        this(new InputStreamReader(input));
    }

    public Gaussian03Reader() {
        this(new StringReader(""));
    }

    public IResourceFormat getFormat() {
        return Gaussian03Format.getInstance();
    }

    public void setReader(Reader reader) throws CDKException {
        this.input = new BufferedReader(reader);
    }

    public void setReader(InputStream input) throws CDKException {
        this.setReader(new InputStreamReader(input));
    }

    public boolean accepts(Class<? extends IChemObject> classObject) {
        Class<?>[] interfaces = classObject.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (IChemFile.class.equals(interfaces[i])) {
                return true;
            }
            if (!IChemSequence.class.equals(interfaces[i])) continue;
            return true;
        }
        return false;
    }

    public <T extends IChemObject> T read(T object) throws CDKException {
        if (object instanceof IChemSequence) {
            return (T)this.readChemSequence((IChemSequence)object);
        }
        if (object instanceof IChemFile) {
            return (T)this.readChemFile((IChemFile)object);
        }
        throw new CDKException("Object " + object.getClass().getName() + " is not supported");
    }

    public void close() throws IOException {
        this.input.close();
    }

    private IChemFile readChemFile(IChemFile chemFile) throws CDKException {
        IChemSequence sequence = this.readChemSequence((IChemSequence)chemFile.getBuilder().newInstance(IChemSequence.class, new Object[0]));
        chemFile.addChemSequence(sequence);
        return chemFile;
    }

    private IChemSequence readChemSequence(IChemSequence sequence) throws CDKException {
        IChemModel model = null;
        try {
            String line = this.input.readLine();
            while (this.input.ready() && line != null) {
                if (line.indexOf("Standard orientation:") >= 0) {
                    model = (IChemModel)sequence.getBuilder().newInstance(IChemModel.class, new Object[0]);
                    try {
                        this.readCoordinates(model);
                        break;
                    }
                    catch (IOException exception) {
                        throw new CDKException("Error while reading coordinates: " + exception.toString(), (Throwable)exception);
                    }
                }
                line = this.input.readLine();
            }
            if (model != null) {
                line = this.input.readLine();
                while (this.input.ready() && line != null) {
                    if (line.indexOf("Standard orientation:") >= 0) {
                        sequence.addChemModel(model);
                        this.fireFrameRead();
                        model = (IChemModel)sequence.getBuilder().newInstance(IChemModel.class, new Object[0]);
                        this.readCoordinates(model);
                    } else if (line.indexOf("SCF Done:") >= 0) {
                        model.setProperty((Object)"org.openscience.cdk.io.Gaussian03Reaer:SCF Done", (Object)line.trim());
                    } else if (line.indexOf("Harmonic frequencies") < 0) {
                        if (line.indexOf("Mulliken atomic charges") >= 0) {
                            this.readPartialCharges(model);
                        } else if (line.indexOf("Magnetic shielding") >= 0 || line.indexOf("GINC") >= 0) {
                            // empty if block
                        }
                    }
                    line = this.input.readLine();
                }
                sequence.addChemModel(model);
                this.fireFrameRead();
            }
        }
        catch (IOException exception) {
            throw new CDKException("Error while reading general structure: " + exception.toString(), (Throwable)exception);
        }
        return sequence;
    }

    private void readCoordinates(IChemModel model) throws CDKException, IOException {
        IAtomContainer container = (IAtomContainer)model.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        String line = this.input.readLine();
        line = this.input.readLine();
        line = this.input.readLine();
        line = this.input.readLine();
        while (this.input.ready() && (line = this.input.readLine()) != null && line.indexOf("-----") < 0) {
            int atomicNumber = 0;
            StringReader sr = new StringReader(line);
            StreamTokenizer token = new StreamTokenizer(sr);
            token.nextToken();
            if (token.nextToken() == -2) {
                atomicNumber = (int)token.nval;
                if (atomicNumber == 0) {
                    continue;
                }
            } else {
                throw new IOException("Error reading coordinates");
            }
            token.nextToken();
            double x = 0.0;
            double y = 0.0;
            double z = 0.0;
            if (token.nextToken() != -2) {
                throw new IOException("Error reading coordinates");
            }
            x = token.nval;
            if (token.nextToken() != -2) {
                throw new IOException("Error reading coordinates");
            }
            y = token.nval;
            if (token.nextToken() != -2) {
                throw new IOException("Error reading coordinates");
            }
            z = token.nval;
            String symbol = "Du";
            symbol = PeriodicTable.getSymbol((int)atomicNumber);
            IAtom atom = (IAtom)model.getBuilder().newInstance(IAtom.class, new Object[]{symbol});
            atom.setPoint3d(new Point3d(x, y, z));
            container.addAtom(atom);
        }
        IAtomContainerSet moleculeSet = (IAtomContainerSet)model.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
        moleculeSet.addAtomContainer((IAtomContainer)model.getBuilder().newInstance(IAtomContainer.class, new Object[]{container}));
        model.setMoleculeSet(moleculeSet);
    }

    private void readPartialCharges(IChemModel model) throws CDKException, IOException {
        logger.info((Object)"Reading partial atomic charges");
        IAtomContainerSet moleculeSet = model.getMoleculeSet();
        IAtomContainer molecule = moleculeSet.getAtomContainer(0);
        String line = this.input.readLine();
        while (this.input.ready()) {
            line = this.input.readLine();
            logger.debug((Object)("Read charge block line: " + line));
            if (line == null || line.indexOf("Sum of Mulliken charges") >= 0) {
                logger.debug((Object)"End of charge block found");
                break;
            }
            StringReader sr = new StringReader(line);
            StreamTokenizer tokenizer = new StreamTokenizer(sr);
            if (tokenizer.nextToken() != -2) continue;
            int atomCounter = (int)tokenizer.nval;
            tokenizer.nextToken();
            double charge = 0.0;
            if (tokenizer.nextToken() != -2) {
                throw new CDKException("Error while reading charge: expected double.");
            }
            charge = tokenizer.nval;
            logger.debug((Object)("Found charge for atom " + atomCounter + ": " + charge));
            IAtom atom = molecule.getAtom(atomCounter - 1);
            atom.setCharge(Double.valueOf(charge));
        }
    }
}

