/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.openscience.cdk.atomtype.SybylAtomTypeMatcher;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.io.DefaultChemObjectWriter;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.Mol2Format;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class Mol2Writer
extends DefaultChemObjectWriter {
    private BufferedWriter writer;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(Mol2Writer.class);
    private SybylAtomTypeMatcher matcher;

    public Mol2Writer() {
        this(new StringWriter());
    }

    public Mol2Writer(Writer out) {
        try {
            this.writer = out instanceof BufferedWriter ? (BufferedWriter)out : new BufferedWriter(out);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Mol2Writer(OutputStream output) {
        this(new OutputStreamWriter(output));
    }

    public IResourceFormat getFormat() {
        return Mol2Format.getInstance();
    }

    public void setWriter(Writer out) throws CDKException {
        this.writer = out instanceof BufferedWriter ? (BufferedWriter)out : new BufferedWriter(out);
    }

    public void setWriter(OutputStream output) throws CDKException {
        this.setWriter(new OutputStreamWriter(output));
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public boolean accepts(Class<? extends IChemObject> classObject) {
        Class<?>[] interfaces;
        if (IAtomContainer.class.equals(classObject)) {
            return true;
        }
        for (Class<?> anInterface : interfaces = classObject.getInterfaces()) {
            if (!IAtomContainer.class.equals(anInterface)) continue;
            return true;
        }
        Class<? extends IChemObject> superClass = classObject.getSuperclass();
        if (superClass != null) {
            return this.accepts(superClass);
        }
        return false;
    }

    public void write(IChemObject object) throws CDKException {
        if (object instanceof IAtomContainer) {
            try {
                this.writeMolecule((IAtomContainer)object);
            }
            catch (Exception ex) {
                throw new CDKException("Error while writing Mol2 file: " + ex.getMessage(), (Throwable)ex);
            }
        } else {
            throw new CDKException("Mol2Writer only supports output of Molecule classes.");
        }
    }

    public void writeMolecule(IAtomContainer mol) throws IOException {
        this.matcher = SybylAtomTypeMatcher.getInstance((IChemObjectBuilder)mol.getBuilder());
        logger.debug((Object)"Writing header...");
        if (mol.getTitle() != null) {
            this.writer.write("#        Name: " + mol.getTitle());
            this.writer.write(10);
        }
        this.writer.write(10);
        logger.debug((Object)"Writing molecule block...");
        this.writer.write("@<TRIPOS>MOLECULE");
        this.writer.write(10);
        if (mol.getID() == null) {
            this.writer.write("CDKMolecule");
        } else {
            this.writer.write(mol.getID());
        }
        this.writer.write(10);
        this.writer.write(mol.getAtomCount() + " " + mol.getBondCount());
        this.writer.write(10);
        this.writer.write("SMALL");
        this.writer.write(10);
        this.writer.write("NO CHARGES");
        this.writer.write(10);
        logger.debug((Object)"Writing atom block...");
        this.writer.write("@<TRIPOS>ATOM");
        this.writer.write(10);
        for (int i = 0; i < mol.getAtomCount(); ++i) {
            IAtom atom = mol.getAtom(i);
            this.writer.write(i + 1 + " " + atom.getSymbol() + (mol.indexOf(atom) + 1) + " ");
            if (atom.getPoint3d() != null) {
                this.writer.write(atom.getPoint3d().x + " ");
                this.writer.write(atom.getPoint3d().y + " ");
                this.writer.write(atom.getPoint3d().z + " ");
            } else if (atom.getPoint2d() != null) {
                this.writer.write(atom.getPoint2d().x + " ");
                this.writer.write(atom.getPoint2d().y + " ");
                this.writer.write(" 0.000 ");
            } else {
                this.writer.write("0.000 0.000 0.000 ");
            }
            IAtomType sybylType = null;
            try {
                sybylType = this.matcher.findMatchingAtomType(mol, atom);
            }
            catch (CDKException e) {
                e.printStackTrace();
            }
            if (sybylType != null) {
                this.writer.write(sybylType.getAtomTypeName());
            } else {
                this.writer.write(atom.getSymbol());
            }
            this.writer.write(10);
        }
        logger.debug((Object)"Writing bond block...");
        this.writer.write("@<TRIPOS>BOND");
        this.writer.write(10);
        int counter = 0;
        for (IBond bond : mol.bonds()) {
            String sybylBondOrder = "-1";
            if (bond.getOrder().equals((Object)IBond.Order.SINGLE)) {
                sybylBondOrder = "1";
            } else if (bond.getOrder().equals((Object)IBond.Order.DOUBLE)) {
                sybylBondOrder = "2";
            } else if (bond.getOrder().equals((Object)IBond.Order.TRIPLE)) {
                sybylBondOrder = "3";
            }
            if (bond.getFlag(32)) {
                sybylBondOrder = "ar";
            }
            IAtom bondAtom1 = bond.getBegin();
            IAtom bondAtom2 = bond.getEnd();
            try {
                IAtomType bondAtom1Type = this.matcher.findMatchingAtomType(mol, bondAtom1);
                IAtomType bondAtom2Type = this.matcher.findMatchingAtomType(mol, bondAtom2);
                if (bondAtom1Type != null && bondAtom2Type != null && (bondAtom1Type.getAtomTypeName().equals("N.am") && bondAtom2Type.getAtomTypeName().equals("C.2") || bondAtom2Type.getAtomTypeName().equals("N.am") && bondAtom1Type.getAtomTypeName().equals("C.2"))) {
                    sybylBondOrder = "am";
                }
            }
            catch (CDKException e) {
                e.printStackTrace();
            }
            this.writer.write(counter + 1 + " " + (mol.indexOf(bond.getBegin()) + 1) + " " + (mol.indexOf(bond.getEnd()) + 1) + " " + sybylBondOrder);
            this.writer.write(10);
            ++counter;
        }
    }
}

