/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.extender.impl;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.inject.spi.CDIProvider;
import org.ops4j.pax.cdi.extender.impl.BundleCdi;
import org.ops4j.pax.cdi.extender.impl.DelegatingCdiContainer;
import org.ops4j.pax.cdi.spi.BeanBundles;
import org.ops4j.pax.cdi.spi.CdiContainer;
import org.ops4j.pax.cdi.spi.CdiContainerFactory;
import org.ops4j.pax.cdi.spi.CdiContainerListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={})
public class CdiExtender
implements BundleTrackerCustomizer<CdiContainer> {
    private static Logger log = LoggerFactory.getLogger(CdiExtender.class);
    private BundleContext context;
    private BundleTracker<CdiContainer> bundleWatcher;
    private CdiContainerFactory factory;
    private CdiContainerListener webAdapter;
    private CDIProvider cdiProvider;
    private Map<Long, Bundle> webBundles = new HashMap<Long, Bundle>();

    @Activate
    public synchronized void activate(BundleContext ctx) {
        this.context = ctx;
        if (this.webAdapter != null) {
            this.handleWebBundles();
        }
        CDI.setCDIProvider((CDIProvider)this.cdiProvider);
        log.info("starting CDI extender {}", (Object)this.context.getBundle().getSymbolicName());
        this.bundleWatcher = new BundleTracker(this.context, 32, (BundleTrackerCustomizer)this);
        this.bundleWatcher.open();
    }

    @Deactivate
    public synchronized void deactivate(BundleContext ctx) {
        BundleCdi.dispose();
        log.info("stopping CDI extender {}", (Object)ctx.getBundle().getSymbolicName());
        this.bundleWatcher.close();
    }

    public synchronized CdiContainer addingBundle(Bundle bundle, BundleEvent event) {
        boolean wired = false;
        List wires = ((BundleWiring)bundle.adapt(BundleWiring.class)).getRequiredWires("osgi.extender");
        if (wires != null) {
            for (BundleWire wire : wires) {
                if (!wire.getProviderWiring().getBundle().equals(this.context.getBundle())) continue;
                wired = true;
                break;
            }
        }
        if (wired) {
            log.debug("found bean bundle: {}", (Object)bundle.getSymbolicName());
            return this.createContainer(bundle);
        }
        log.trace("not a bean bundle: {}", (Object)bundle.getSymbolicName());
        return null;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, CdiContainer object) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removedBundle(Bundle bundle, BundleEvent event, CdiContainer container) {
        if (container != null) {
            CdiContainer cdiContainer = container;
            synchronized (cdiContainer) {
                container.stop();
            }
        }
        this.factory.removeContainer(bundle);
        if (this.webAdapter != null) {
            this.webAdapter.preDestroy(container);
        }
    }

    private CdiContainer createContainer(Bundle bundle) {
        Dictionary headers = bundle.getHeaders();
        String contextPath = (String)headers.get("Web-ContextPath");
        boolean isWebBundle = contextPath != null;
        CdiContainer container = null;
        if (isWebBundle) {
            if (this.webAdapter == null) {
                log.debug("waiting for web adapter for {}", (Object)bundle);
                this.webBundles.put(bundle.getBundleId(), bundle);
            } else {
                container = this.doCreateLazyContainer(bundle);
            }
        } else {
            container = this.doCreateContainer(bundle);
            container.start(new Object());
        }
        return container;
    }

    private CdiContainer doCreateContainer(Bundle bundle) {
        HashSet extensions = new HashSet();
        BeanBundles.findExtensions((Bundle)bundle, extensions);
        log.info("creating CDI container for bean bundle {} with extension bundles {}", (Object)bundle, extensions);
        return this.factory.createContainer(bundle, extensions);
    }

    private CdiContainer doCreateLazyContainer(Bundle bundle) {
        DelegatingCdiContainer container = new DelegatingCdiContainer(this.factory, bundle);
        if (this.webAdapter != null) {
            this.webAdapter.postCreate((CdiContainer)container);
        }
        return container;
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, target="(type=web)")
    public synchronized void setWebAdapter(CdiContainerListener listener) {
        log.debug("adding web adapter");
        this.webAdapter = listener;
        if (this.context != null) {
            this.handleWebBundles();
        }
    }

    private void handleWebBundles() {
        this.factory.addListener(this.webAdapter);
        for (Bundle bundle : this.webBundles.values()) {
            this.doCreateLazyContainer(bundle);
        }
        this.webBundles.clear();
    }

    public synchronized void unsetWebAdapter(CdiContainerListener listener) {
        if (this.factory != null) {
            this.factory.removeListener(listener);
        }
        this.webAdapter = null;
    }

    @Reference
    public synchronized void setCdiContainerFactory(CdiContainerFactory cdiContainerFactory) {
        this.factory = cdiContainerFactory;
    }

    @Reference
    public synchronized void setCdiProvider(CDIProvider cdiProvider) {
        this.cdiProvider = cdiProvider;
    }
}

