/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.extender.impl;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.BeanManager;
import org.ops4j.pax.cdi.spi.BeanBundles;
import org.ops4j.pax.cdi.spi.CdiContainer;
import org.ops4j.pax.cdi.spi.CdiContainerFactory;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegatingCdiContainer
implements CdiContainer {
    private static Logger log = LoggerFactory.getLogger(DelegatingCdiContainer.class);
    private CdiContainerFactory factory;
    private Bundle bundle;
    private CdiContainer delegate;

    public DelegatingCdiContainer(CdiContainerFactory factory, Bundle bundle) {
        this.factory = factory;
        this.bundle = bundle;
    }

    public synchronized void start(Object environment) {
        HashSet extensions = new HashSet();
        BeanBundles.findExtensions((Bundle)this.bundle, extensions);
        log.info("creating CDI container for bean bundle {} with extension bundles {}", (Object)this.bundle, extensions);
        this.delegate = this.factory.createContainer(this.bundle, extensions);
        this.delegate.start(environment);
    }

    public synchronized void stop() {
        if (this.delegate != null) {
            this.delegate.stop();
            this.delegate = null;
        }
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public synchronized BeanManager getBeanManager() {
        if (this.delegate != null) {
            return this.delegate.getBeanManager();
        }
        return null;
    }

    public <T> Event<T> getEvent() {
        if (this.delegate != null) {
            return this.delegate.getEvent();
        }
        return null;
    }

    public <T> Instance<T> getInstance() {
        if (this.delegate != null) {
            return this.delegate.getInstance();
        }
        return null;
    }

    public ClassLoader getContextClassLoader() {
        return this.delegate.getContextClassLoader();
    }

    public <T> T unwrap(Class<T> wrappedClass) {
        return (T)this.delegate.unwrap(wrappedClass);
    }

    public void startContext(Class<? extends Annotation> scope) {
        this.delegate.startContext(scope);
    }

    public void stopContext(Class<? extends Annotation> scope) {
        this.delegate.stopContext(scope);
    }
}

