/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.karaf.container.internal;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import org.ops4j.pax.exam.karaf.options.KarafDistributionBaseConfigurationOption;
import org.ops4j.pax.exam.karaf.options.KarafDistributionConfigurationOption;

public class InternalKarafDistributionConfigurationOption
extends KarafDistributionConfigurationOption {
    private static final String NAME = "name";
    private static final String KARAF_VERSION = "karafVersion";
    private File distributionInfo;

    public InternalKarafDistributionConfigurationOption(KarafDistributionBaseConfigurationOption distributionConfigurationOption, File distributionInfo) {
        super(distributionConfigurationOption);
        this.distributionInfo = distributionInfo;
    }

    @Override
    public String getKarafVersion() {
        String internalVersion = super.getKarafVersion();
        if (internalVersion != null && internalVersion.length() != 0) {
            return internalVersion;
        }
        if (!this.distributionInfo.exists()) {
            throw new IllegalStateException("Either distribution.info or the property itself has to define a karaf version.");
        }
        String retrieveProperty = this.retrieveProperty(KARAF_VERSION);
        if (retrieveProperty == null || retrieveProperty.length() == 0) {
            throw new IllegalStateException("Either distribution.info or the property itself has to define a karaf version.");
        }
        return retrieveProperty;
    }

    @Override
    public String getName() {
        String internalName = super.getName();
        if (internalName != null && internalName.length() != 0) {
            return internalName;
        }
        if (!this.distributionInfo.exists()) {
            throw new IllegalStateException("Either distribution.info or the property itself has to define a name for the distribution..");
        }
        String retrieveProperty = this.retrieveProperty(NAME);
        if (retrieveProperty == null || retrieveProperty.length() == 0) {
            throw new IllegalStateException("Either distribution.info or the property itself has to define a name for the distribution..");
        }
        return retrieveProperty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String retrieveProperty(String key) {
        String string;
        FileInputStream fileInputStream = new FileInputStream(this.distributionInfo);
        try {
            Properties props = new Properties();
            props.load(fileInputStream);
            string = props.getProperty(key);
        }
        catch (Throwable throwable) {
            try {
                fileInputStream.close();
                throw throwable;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        fileInputStream.close();
        return string;
    }
}

