/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.container.def.internal;

import java.io.IOException;
import java.io.InputStream;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.ExamSystem;
import org.ops4j.pax.exam.Info;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.RelativeTimeout;
import org.ops4j.pax.exam.TestAddress;
import org.ops4j.pax.exam.TestContainer;
import org.ops4j.pax.exam.TimeoutException;
import org.ops4j.pax.exam.container.def.internal.ArgumentsBuilder;
import org.ops4j.pax.exam.container.def.internal.AsyncJavaRunner;
import org.ops4j.pax.exam.container.def.internal.RMIRegistry;
import org.ops4j.pax.exam.container.remote.RBCRemoteTarget;
import org.ops4j.pax.exam.options.FrameworkOption;
import org.ops4j.pax.exam.options.ServerModeOption;
import org.ops4j.pax.exam.rbc.client.RemoteBundleContextClient;
import org.ops4j.pax.runner.Run;
import org.ops4j.pax.runner.handler.internal.URLUtils;
import org.ops4j.pax.runner.platform.DefaultJavaRunner;
import org.ops4j.pax.runner.platform.JavaRunner;
import org.ops4j.pax.runner.platform.StoppableJavaRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaxRunnerTestContainer
implements TestContainer {
    private static final String RUNNER_TEST_CONTAINER = "PaxRunnerTestContainer.start";
    private static final Logger LOG = LoggerFactory.getLogger(PaxRunnerTestContainer.class);
    private static final boolean BLOCKING_RUNNER_INTERNALLY = true;
    public static final int SYSTEM_BUNDLE = 0;
    private final StoppableJavaRunner m_javaRunner = new AsyncJavaRunner((StoppableJavaRunner)new DefaultJavaRunner(true));
    private final RMIRegistry m_reg;
    private final FrameworkOption m_selectedFramework;
    private boolean m_started = false;
    private RBCRemoteTarget m_target;
    private final ExamSystem m_system;

    public PaxRunnerTestContainer(ExamSystem system, RMIRegistry registry, FrameworkOption selectedFramework) {
        this.m_reg = registry;
        this.m_system = system;
        this.m_selectedFramework = selectedFramework;
    }

    public synchronized TestContainer start() {
        try {
            String name = this.m_system.createID(RUNNER_TEST_CONTAINER);
            ExamSystem m_subsystem = this.m_system.fork(CoreOptions.options((Option[])new Option[]{CoreOptions.systemProperty((String)"org.ops4j.pax.exam.rbc.rmi.host").value(this.m_reg.getHost()), CoreOptions.systemProperty((String)"org.ops4j.pax.exam.rbc.rmi.port").value("" + this.m_reg.getPort()), CoreOptions.systemProperty((String)"org.ops4j.pax.exam.rbc.rmi.name").value(name)}));
            this.m_target = new RBCRemoteTarget(name, Integer.valueOf(this.m_reg.getPort()), m_subsystem.getTimeout());
            long startedAt = System.currentTimeMillis();
            URLUtils.resetURLStreamHandlerFactory();
            String[] arguments = ArgumentsBuilder.build(m_subsystem, this.m_selectedFramework);
            this.printExtraBeforeStart(arguments);
            Run.start((JavaRunner)this.m_javaRunner, (String[])arguments);
            LOG.debug("Test Container started in " + (System.currentTimeMillis() - startedAt) + " millis");
            LOG.info("Wait for test container to finish its initialization " + m_subsystem.getTimeout());
            if (((ServerModeOption[])m_subsystem.getOptions(ServerModeOption.class)).length == 0) {
                this.waitForState(0L, 32, m_subsystem.getTimeout());
            } else {
                LOG.info("System runs in Server Mode. Which means, not Test facility bundles available on target system.");
            }
            this.m_started = true;
        }
        catch (IOException e) {
            throw new RuntimeException("Problem starting container");
        }
        return this;
    }

    private void printExtraBeforeStart(String[] arguments) {
        LOG.debug("Starting up the test container (Pax Runner " + Info.getPaxRunnerVersion() + " )");
        LOG.debug("Pax Runner Arguments: ( " + arguments.length + ")");
        for (String s : arguments) {
            LOG.debug("#   " + s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized TestContainer stop() {
        block6: {
            LOG.debug("Shutting down the test container (Pax Runner)");
            try {
                if (this.m_started) {
                    this.m_target.stop();
                    RemoteBundleContextClient remoteBundleContextClient = this.m_target.getClientRBC();
                    if (remoteBundleContextClient != null) {
                        remoteBundleContextClient.stop();
                    }
                    if (this.m_javaRunner != null) {
                        this.m_javaRunner.shutdown();
                    }
                    break block6;
                }
                throw new RuntimeException("Container never came up");
            }
            finally {
                this.m_started = false;
                this.m_target = null;
                this.m_system.clear();
            }
        }
        return this;
    }

    private void waitForState(long bundleId, int state, RelativeTimeout timeout) throws TimeoutException {
        this.m_target.getClientRBC().waitForState(bundleId, state, timeout);
    }

    public synchronized void call(TestAddress address) {
        this.m_target.call(address);
    }

    public synchronized long install(InputStream stream) {
        return this.install("local", stream);
    }

    public synchronized long install(String location, InputStream stream) {
        return this.m_target.install(location, stream);
    }

    public String toString() {
        return "PaxRunnerTestContainer{" + this.m_selectedFramework.getName() + "}";
    }
}

