/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.junit;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.ops4j.pax.exam.ExamConfigurationException;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.TestAddress;
import org.ops4j.pax.exam.TestContainerException;
import org.ops4j.pax.exam.TestContainerFactory;
import org.ops4j.pax.exam.TestProbeBuilder;
import org.ops4j.pax.exam.junit.Configuration;
import org.ops4j.pax.exam.junit.ExamFactory;
import org.ops4j.pax.exam.junit.ExamReactorStrategy;
import org.ops4j.pax.exam.junit.ProbeBuilder;
import org.ops4j.pax.exam.spi.ExxamReactor;
import org.ops4j.pax.exam.spi.StagedExamReactor;
import org.ops4j.pax.exam.spi.StagedExamReactorFactory;
import org.ops4j.pax.exam.spi.container.PaxExamRuntime;
import org.ops4j.pax.exam.spi.container.PlumbingContext;
import org.ops4j.pax.exam.spi.driversupport.DefaultExamReactor;
import org.ops4j.pax.exam.spi.reactors.AllConfinedStagedReactorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnit4TestRunner
extends BlockJUnit4ClassRunner {
    private static Logger LOG = LoggerFactory.getLogger(JUnit4TestRunner.class);
    private final StagedExamReactor m_reactor;
    private final Map<TestAddress, FrameworkMethod> m_map = new HashMap<TestAddress, FrameworkMethod>();
    private final Map<FrameworkMethod, TestAddress> m__childs = new HashMap<FrameworkMethod, TestAddress>();

    public JUnit4TestRunner(Class<?> klass) throws Exception {
        super(klass);
        this.m_reactor = this.prepareReactor();
    }

    public void run(RunNotifier notifier) {
        try {
            super.run(notifier);
        }
        catch (Exception e) {
            throw new TestContainerException("Problem interacting with reactor.", (Throwable)e);
        }
        finally {
            this.m_reactor.tearDown();
        }
    }

    protected List<FrameworkMethod> getChildren() {
        ArrayList<FrameworkMethod> childs = new ArrayList<FrameworkMethod>();
        for (final TestAddress address : this.m_reactor.getTargets()) {
            FrameworkMethod frameworkMethod = this.m_map.get(address.root());
            FrameworkMethod method = new FrameworkMethod(frameworkMethod.getMethod()){

                public String getName() {
                    return address.caption();
                }

                public boolean equals(Object obj) {
                    return address.equals(obj);
                }

                public int hashCode() {
                    return address.hashCode();
                }
            };
            this.m__childs.put(method, address);
            childs.add(method);
        }
        return childs;
    }

    protected void collectInitializationErrors(List<Throwable> errors) {
    }

    private synchronized StagedExamReactor prepareReactor() throws Exception {
        Class testClass = this.getTestClass().getJavaClass();
        Object testClassInstance = testClass.newInstance();
        DefaultExamReactor reactor = this.getReactor(testClass);
        this.addConfigurationsToReactor((ExxamReactor)reactor, testClass, testClassInstance);
        this.addTestsToReactor((ExxamReactor)reactor, testClass, testClassInstance);
        return reactor.stage(this.getFactory(testClass));
    }

    private void addConfigurationsToReactor(ExxamReactor reactor, Class testClass, Object testClassInstance) throws IllegalAccessException, InvocationTargetException {
        Method[] methods;
        for (Method m : methods = testClass.getMethods()) {
            Configuration conf = m.getAnnotation(Configuration.class);
            if (conf == null) continue;
            LOG.info("Add Configuration " + m.getName());
            reactor.addConfiguration((Option[])m.invoke(testClassInstance, new Object[0]));
        }
    }

    private void addTestsToReactor(ExxamReactor reactor, Class testClass, Object testClassInstance) throws IOException, ExamConfigurationException {
        Properties extraProperties = new Properties();
        TestProbeBuilder probe = new PlumbingContext().createProbe(extraProperties);
        probe = this.overwriteWithUserDefinition(testClass, testClassInstance, probe);
        for (FrameworkMethod s : super.getChildren()) {
            this.m_map.put(probe.addTest(testClass, s.getMethod().getName()), s);
        }
        reactor.addProbe(probe.build());
    }

    private StagedExamReactorFactory getFactory(Class testClass) throws InstantiationException, IllegalAccessException {
        ExamReactorStrategy strategy = testClass.getAnnotation(ExamReactorStrategy.class);
        Object fact = strategy != null ? strategy.value()[0].newInstance() : new AllConfinedStagedReactorFactory();
        return fact;
    }

    private DefaultExamReactor getReactor(Class testClass) throws InstantiationException, IllegalAccessException {
        return new DefaultExamReactor(this.getExamFactory(testClass));
    }

    private TestContainerFactory getExamFactory(Class testClass) throws IllegalAccessException, InstantiationException {
        ExamFactory f = testClass.getAnnotation(ExamFactory.class);
        TestContainerFactory fact = f != null ? f.value().newInstance() : PaxExamRuntime.getTestContainerFactory();
        return fact;
    }

    protected synchronized Statement methodInvoker(final FrameworkMethod method, Object test) {
        return new Statement(){

            public void evaluate() throws Throwable {
                TestAddress address = (TestAddress)JUnit4TestRunner.this.m__childs.get(method);
                LOG.info("Invoke " + method.getName() + " @ " + address);
                JUnit4TestRunner.this.m_reactor.invoke(address, new Object[0]);
            }
        };
    }

    protected void validatePublicVoidNoArgMethods(Class<? extends Annotation> annotation, boolean isStatic, List<Throwable> errors) {
    }

    private TestProbeBuilder overwriteWithUserDefinition(Class testClass, Object instance, TestProbeBuilder probe) throws ExamConfigurationException {
        Method[] methods;
        for (Method m : methods = testClass.getMethods()) {
            TestProbeBuilder probeBuilder;
            ProbeBuilder conf = m.getAnnotation(ProbeBuilder.class);
            if (conf == null) continue;
            LOG.debug("User defined probe hook found: " + m.getName());
            try {
                probeBuilder = (TestProbeBuilder)m.invoke(instance, probe);
            }
            catch (Exception e) {
                throw new ExamConfigurationException("Invoking custom probe hook " + m.getName() + " failed", e);
            }
            if (probeBuilder != null) {
                return probe;
            }
            throw new ExamConfigurationException("Invoking custom probe hook " + m.getName() + " succeeded but returned null");
        }
        LOG.debug("No User defined probe hook found");
        return probe;
    }
}

