/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.spi.container;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.ServiceLoader;
import org.ops4j.pax.exam.TestContainerException;
import org.ops4j.pax.exam.TestContainerFactory;
import org.ops4j.pax.exam.TestTargetFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PaxExamRuntime {
    private static final Logger LOG = LoggerFactory.getLogger(PaxExamRuntime.class);

    private PaxExamRuntime() {
    }

    public static TestContainerFactory getTestContainerFactory() {
        PaxExamRuntime.sanityCheck();
        TestContainerFactory factory = ServiceLoader.load(TestContainerFactory.class).iterator().next();
        LOG.debug("Found TestContainerFactory: " + (factory != null ? factory.getClass().getName() : "<NONE>"));
        return factory;
    }

    private static void sanityCheck() {
        try {
            ArrayList<URL> factories = new ArrayList<URL>();
            Enumeration<URL> systemResources = ClassLoader.getSystemResources("META-INF/services/org.ops4j.pax.exam.TestContainerFactory");
            while (systemResources.hasMoreElements()) {
                factories.add(systemResources.nextElement());
            }
            if (factories.size() == 0) {
                throw new TestContainerException("No TestContainer implementation in Classpath.. ");
            }
            if (factories.size() > 1) {
                for (URL fac : factories) {
                    LOG.error("Ambiquous TestContainer:  " + fac.toExternalForm());
                }
                throw new TestContainerException("Too many TestContainer implementations in Classpath.. ");
            }
            return;
        }
        catch (IOException e) {
            throw new TestContainerException("Problem looking for TestContainerFactory descriptors in Classpath.. ", (Throwable)e);
        }
    }

    public static TestContainerFactory getTestContainerFactory(Class<? extends TestContainerFactory> select) {
        try {
            return select.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Class  " + select + "is not a valid Test Container Factory.", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Class  " + select + "is not a valid Test Container Factory.", e);
        }
    }

    public static TestTargetFactory getTestTargetFactory() {
        return ServiceLoader.load(TestTargetFactory.class).iterator().next();
    }
}

