/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.spi.driversupport;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.TestContainer;
import org.ops4j.pax.exam.TestContainerFactory;
import org.ops4j.pax.exam.TestProbeProvider;
import org.ops4j.pax.exam.spi.ExxamReactor;
import org.ops4j.pax.exam.spi.StagedExamReactor;
import org.ops4j.pax.exam.spi.StagedExamReactorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExamReactor
implements ExxamReactor {
    private static Logger LOG = LoggerFactory.getLogger(DefaultExamReactor.class);
    private final List<Option[]> m_configurations = new ArrayList<Option[]>();
    private final List<TestProbeProvider> m_probes = new ArrayList<TestProbeProvider>();
    private final TestContainerFactory m_factory;

    public DefaultExamReactor(TestContainerFactory factory) {
        this.m_factory = factory;
    }

    public synchronized void addConfiguration(Option[] options) {
        this.m_configurations.add(options);
    }

    public synchronized void addProbe(TestProbeProvider addTest) {
        this.m_probes.add(addTest);
    }

    public synchronized StagedExamReactor stage(StagedExamReactorFactory factory) {
        LOG.info("Staging reactor with probes: " + this.m_probes.size() + " using strategy: " + factory);
        ArrayList<TestContainer> containers = new ArrayList<TestContainer>();
        if (this.m_configurations.isEmpty()) {
            LOG.info("No configuration given. Setting an empty one.");
            this.m_configurations.add(CoreOptions.options((Option[])new Option[0]));
        }
        for (Option[] options : this.m_configurations) {
            containers.addAll(Arrays.asList(this.m_factory.parse(options)));
        }
        return factory.create(containers, this.m_probes);
    }
}

