/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.spi.probesupport.intern;

import aQute.lib.osgi.Analyzer;
import aQute.lib.osgi.Jar;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Properties;
import java.util.jar.Manifest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.lang.NullArgumentException;

public class BndWrapper {
    private static final Log LOG = LogFactory.getLog(BndWrapper.class);

    private BndWrapper() {
    }

    public static InputStream createBundle(InputStream jarInputStream, String jarInfo, Properties ... instructions) throws Exception {
        NullArgumentException.validateNotNull((Object)jarInputStream, (String)"Jar URL");
        NullArgumentException.validateNotNull((Object)instructions, (String)"Instructions");
        NullArgumentException.validateNotEmpty((String)jarInfo, (String)"Jar info");
        LOG.debug((Object)("Creating bundle for [" + jarInfo + "]"));
        Jar jar = new Jar("dot", jarInputStream);
        Manifest manifest = jar.getManifest();
        Analyzer analyzer = new Analyzer();
        analyzer.setJar(jar);
        for (Properties in : instructions) {
            LOG.trace((Object)("+ Using instructions " + in));
            analyzer.setProperties(in);
            analyzer.mergeManifest(manifest);
        }
        BndWrapper.checkMandatoryProperties(analyzer, jar, jarInfo);
        analyzer.calcManifest();
        return BndWrapper.createInputStream(jar);
    }

    private static PipedInputStream createInputStream(final Jar jar) throws IOException {
        PipedInputStream pin = new PipedInputStream();
        final PipedOutputStream pout = new PipedOutputStream(pin);
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    jar.write((OutputStream)pout);
                }
                catch (IOException e) {
                    LOG.warn((Object)"Bundle cannot be generated");
                }
                finally {
                    try {
                        jar.close();
                        pout.close();
                    }
                    catch (IOException ignore) {
                        LOG.error((Object)"Bundle cannot be generated", (Throwable)ignore);
                    }
                }
            }
        }.start();
        return pin;
    }

    private static void checkMandatoryProperties(Analyzer analyzer, Jar jar, String symbolicName) {
        String exportPackage;
        String importPackage = analyzer.getProperty("Import-Package");
        if (importPackage == null || importPackage.trim().length() == 0) {
            analyzer.setProperty("Import-Package", "*;resolution:=optional");
        }
        if ((exportPackage = analyzer.getProperty("Export-Package")) == null || exportPackage.trim().length() == 0) {
            analyzer.setProperty("Export-Package", analyzer.calculateExportsFromContents(jar));
        }
        String localSymbolicName = analyzer.getProperty("Bundle-SymbolicName", symbolicName);
        analyzer.setProperty("Bundle-SymbolicName", BndWrapper.generateSymbolicName(localSymbolicName));
    }

    private static String generateSymbolicName(String symbolicName) {
        return symbolicName.replaceAll("[^a-zA-Z_0-9.-]", "_");
    }
}

