/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.spi.probesupport.intern;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import org.ops4j.pax.exam.spi.probesupport.ContentCollector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectFromBase
implements ContentCollector {
    private File m_base;

    public CollectFromBase(File base) {
        this.m_base = base;
    }

    @Override
    public void collect(Map<String, URL> map) throws IOException {
        this.collectFromBase(map, this.m_base);
    }

    private void collectFromBase(Map<String, URL> map, File dir) throws IOException {
        if (dir != null && dir.canRead() && dir.isDirectory()) {
            for (File f : dir.listFiles()) {
                if (f.isDirectory()) {
                    this.collectFromBase(map, f);
                    continue;
                }
                if (f.isHidden()) continue;
                map.put(this.normalize(this.m_base, f), f.toURI().toURL());
            }
        }
    }

    private String normalize(File base, File f) throws IOException {
        return f.getCanonicalPath().substring(base.getCanonicalPath().length() + 1).replace(File.separatorChar, '/');
    }
}

