/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.spi.probesupport.intern;

import com.google.common.io.Closeables;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.ops4j.io.StreamUtils;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.exam.spi.probesupport.ContentCollector;
import org.ops4j.pax.exam.spi.probesupport.ResourceWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultResourceWriter
implements ResourceWriter {
    private final Logger LOG = LoggerFactory.getLogger(DefaultResourceWriter.class);
    private Map<String, URL> m_items = new LinkedHashMap<String, URL>();

    public DefaultResourceWriter(ContentCollector collector) throws IOException {
        collector.collect(this.m_items);
    }

    public void write(JarOutputStream target) throws IOException {
        NullArgumentException.validateNotNull((Object)target, (String)"target");
        for (String name : this.m_items.keySet()) {
            this.evictManifest();
            InputStream in = this.m_items.get(name).openStream();
            try {
                this.write(name, in, target);
            }
            catch (Exception e) {
                Closeables.closeQuietly((Closeable)in);
            }
        }
    }

    private void evictManifest() {
    }

    void write(String name, InputStream fileIn, JarOutputStream target) throws IOException {
        if (name.endsWith(".class")) {
            fileIn = this.transform(fileIn);
        }
        target.putNextEntry(new JarEntry(name));
        StreamUtils.copyStream((InputStream)fileIn, (OutputStream)target, (boolean)false);
    }

    private InputStream transform(InputStream inputStream) throws IOException {
        ClassReader cr = new ClassReader(inputStream);
        ClassWriter cw = new ClassWriter(cr, 0);
        EvilTypeRemover transformer = new EvilTypeRemover((ClassVisitor)cw);
        cr.accept((ClassVisitor)transformer, 0);
        return new ByteArrayInputStream(cw.toByteArray());
    }

    private class EvilTypeRemover
    extends ClassAdapter {
        public EvilTypeRemover(ClassVisitor classVisitor) {
            super(classVisitor);
        }

        public MethodVisitor visitMethod(int i, String s, String s1, String s2, String[] strings) {
            if (s1.equals("()[Lorg/ops4j/pax/exam/Option;")) {
                DefaultResourceWriter.this.LOG.debug("Successfully removed configuration method \"" + s + "\" from regression plan.");
                return null;
            }
            return super.visitMethod(i, s, s1, s2, strings);
        }
    }
}

