/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.spi.probesupport.intern;

import java.util.UUID;
import org.ops4j.pax.exam.TestAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTestAddress
implements TestAddress {
    private static Logger LOG = LoggerFactory.getLogger(DefaultTestAddress.class);
    private final String m_sig = this.calculate();
    private final TestAddress m_root;
    private final String m_caption;

    public DefaultTestAddress(String caption) {
        this(null, caption);
    }

    public DefaultTestAddress(TestAddress parent, String caption) {
        this.m_caption = parent != null ? parent.caption() + ":" + caption : caption;
        this.m_root = this.calculateRoot(parent);
        LOG.info("NEW ADDRESS= " + this.m_sig + " parent=" + parent + " root=" + this.m_root);
    }

    private String calculate() {
        return "PaxExam-" + UUID.randomUUID().toString();
    }

    public int hashCode() {
        return this.m_sig.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof TestAddress) {
            return o.equals(this.m_sig);
        }
        return false;
    }

    public String identifier() {
        return this.m_sig;
    }

    public String caption() {
        return this.m_caption;
    }

    private TestAddress calculateRoot(TestAddress parent) {
        if (parent != null) {
            return parent.root();
        }
        return this;
    }

    public TestAddress root() {
        return this.m_root;
    }

    public String toString() {
        return "[TestAddress:" + this.m_sig + " root:" + this.m_root.identifier() + "]";
    }
}

