/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.spi.probesupport.intern;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.ops4j.pax.exam.TestAddress;
import org.ops4j.pax.exam.TestContainerException;
import org.ops4j.pax.exam.TestInstantiationInstruction;
import org.ops4j.pax.exam.TestProbeBuilder;
import org.ops4j.pax.exam.TestProbeProvider;
import org.ops4j.pax.exam.spi.probesupport.ContentCollector;
import org.ops4j.pax.exam.spi.probesupport.intern.BundleBuilder;
import org.ops4j.pax.exam.spi.probesupport.intern.ClassSourceFolder;
import org.ops4j.pax.exam.spi.probesupport.intern.CollectFromBase;
import org.ops4j.pax.exam.spi.probesupport.intern.CollectFromItems;
import org.ops4j.pax.exam.spi.probesupport.intern.DefaultResourceWriter;
import org.ops4j.pax.exam.spi.probesupport.intern.DefaultTestAddress;
import org.ops4j.pax.exam.spi.probesupport.intern.DefaultTestProbeProvider;
import org.ops4j.store.Store;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestProbeBuilderImpl
implements TestProbeBuilder {
    private static Logger LOG = LoggerFactory.getLogger(TestProbeBuilderImpl.class);
    private Map<TestAddress, TestInstantiationInstruction> m_probeCalls = new HashMap<TestAddress, TestInstantiationInstruction>();
    private final List<Class> m_anchors;
    private final Properties m_extraProperties;
    private final Set<String> m_ignorePackages = new HashSet<String>();
    private final Store<InputStream> m_store;

    public TestProbeBuilderImpl(Properties p, Store<InputStream> store) throws IOException {
        this.m_anchors = new ArrayList<Class>();
        this.m_store = store;
        this.m_extraProperties = p;
    }

    public TestAddress addTest(Class clazz, String m) {
        DefaultTestAddress address = new DefaultTestAddress(m);
        this.m_probeCalls.put(address, new TestInstantiationInstruction(clazz.getName() + ";" + m));
        this.addAnchor(clazz);
        return address;
    }

    public List<TestAddress> addTests(Class clazz, Method ... methods) {
        ArrayList<TestAddress> list = new ArrayList<TestAddress>();
        for (Method method : methods) {
            list.add(this.addTest(clazz, method.getName()));
        }
        return list;
    }

    public TestProbeBuilder addAnchor(Class clazz) {
        this.m_anchors.add(clazz);
        return this;
    }

    public TestProbeBuilder setHeader(String key, String value) {
        this.m_extraProperties.put(key, value);
        return this;
    }

    public TestProbeBuilder ignorePackageOf(Class ... classes) {
        for (Class c : classes) {
            this.m_ignorePackages.add(c.getPackage().getName());
        }
        return this;
    }

    public TestProbeProvider build() {
        if (this.m_anchors.size() == 0) {
            throw new TestContainerException("No tests added to setup!");
        }
        this.constructProbeTag(this.m_extraProperties);
        Properties p = this.createExtraIgnores();
        try {
            ContentCollector collector = this.selectCollector(new File("."));
            BundleBuilder bundleBuilder = new BundleBuilder(new DefaultResourceWriter(collector), this.m_extraProperties, p);
            return new DefaultTestProbeProvider(this.getTests(), this.m_store, this.m_store.store((Object)bundleBuilder.build()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private ContentCollector selectCollector(File dir) throws IOException {
        this.validateTopLevelDir(dir);
        ContentCollector collector = null;
        File root = new ClassSourceFolder(dir).find(this.m_anchors.get(0));
        collector = root != null ? new CollectFromBase(root) : new CollectFromItems(this.m_anchors);
        return collector;
    }

    private void validateTopLevelDir(File f) {
        if (!(f.exists() && f.canRead() && f.isDirectory())) {
            throw new IllegalArgumentException("topLevelDir " + f.getAbsolutePath() + " is not a readable folder");
        }
        LOG.debug("Top level dir " + f + " has been verified.");
    }

    private TestAddress[] getTests() {
        return this.m_probeCalls.keySet().toArray(new TestAddress[this.m_probeCalls.size()]);
    }

    private Properties createExtraIgnores() {
        Properties extraProperties = new Properties();
        StringBuilder sb = new StringBuilder();
        for (String p : this.m_ignorePackages) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(p);
        }
        extraProperties.put("Ignore-Package", sb.toString());
        return extraProperties;
    }

    private void constructProbeTag(Properties p) {
        StringBuilder sbKeyChain = new StringBuilder();
        for (TestAddress address : this.m_probeCalls.keySet()) {
            sbKeyChain.append(address.identifier());
            sbKeyChain.append(",");
            p.put(address.identifier(), this.m_probeCalls.get(address).toString());
        }
        p.put("PaxExam-Executable", sbKeyChain.toString());
    }

    private List<TestInstantiationInstruction> parseMethods(Class clazz) {
        ArrayList<TestInstantiationInstruction> calls = new ArrayList<TestInstantiationInstruction>();
        for (Method m : clazz.getDeclaredMethods()) {
            if (Modifier.isPublic(m.getModifiers())) {
                calls.add(new TestInstantiationInstruction(clazz + ";" + m));
                continue;
            }
            LOG.debug("Skipping " + clazz.getName() + " Method " + m.getName() + " (not public)");
        }
        return calls;
    }
}

