/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.spi.reactors;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.ops4j.pax.exam.TestAddress;
import org.ops4j.pax.exam.TestContainer;
import org.ops4j.pax.exam.TestProbeProvider;
import org.ops4j.pax.exam.spi.StagedExamReactor;
import org.ops4j.pax.exam.spi.probesupport.intern.DefaultTestAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllConfinedStagedReactor
implements StagedExamReactor {
    private static Logger LOG = LoggerFactory.getLogger(AllConfinedStagedReactor.class);
    private final List<TestProbeProvider> m_probes;
    private final HashMap<TestAddress, TestContainer> m_map;

    public AllConfinedStagedReactor(List<TestContainer> containers, List<TestProbeProvider> mProbes) {
        this.m_probes = mProbes;
        this.m_map = new HashMap();
        for (TestContainer container : containers) {
            for (TestProbeProvider builder : this.m_probes) {
                for (TestAddress a : builder.getTests()) {
                    this.m_map.put(new DefaultTestAddress(a, container.toString()), container);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(TestAddress address, Object ... args) throws Exception {
        assert (address != null) : "TestAddress must not be null.";
        TestContainer container = this.m_map.get(address);
        if (container == null) {
            throw new IllegalArgumentException("TestAddress " + address + " not from this reactor? Got it from getTargets() really?");
        }
        container.start();
        try {
            for (TestProbeProvider builder : this.m_probes) {
                LOG.info("installing probe " + builder);
                container.install(builder.getStream());
            }
            LOG.info("___________Invoke " + address + " against container: " + container);
            container.call(address, args);
        }
        finally {
            container.stop();
        }
    }

    @Override
    public Set<TestAddress> getTargets() {
        return this.m_map.keySet();
    }

    @Override
    public void tearDown() {
    }
}

