/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jdbc.config.impl;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ops4j.pax.jdbc.config.impl.DataSourceFactoryTracker;
import org.ops4j.pax.jdbc.config.impl.DataSourceRegistration;
import org.ops4j.pax.jdbc.config.impl.Decryptor;
import org.ops4j.pax.jdbc.config.impl.ExternalConfigLoader;
import org.ops4j.pax.jdbc.config.impl.PooledDataSourceFactoryTracker;
import org.ops4j.pax.jdbc.pool.common.PooledDataSourceFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.jdbc.DataSourceFactory;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceConfigManager
implements ManagedServiceFactory {
    private Logger LOG = LoggerFactory.getLogger(DataSourceConfigManager.class);
    BundleContext context;
    private Map<String, ServiceTracker> trackers;
    private Decryptor decryptor;
    private ExternalConfigLoader externalConfigLoader;

    public DataSourceConfigManager(BundleContext context, Decryptor decryptor, ExternalConfigLoader externalConfigLoader) {
        this.context = context;
        this.trackers = new HashMap<String, ServiceTracker>();
        this.decryptor = decryptor;
        this.externalConfigLoader = externalConfigLoader;
    }

    public String getName() {
        return "datasource";
    }

    public void updated(String pid, Dictionary config) throws ConfigurationException {
        this.deleted(pid);
        if (config == null) {
            return;
        }
        try {
            ServiceTracker tracker;
            Filter dsfFilter = this.getDSFFilter(config);
            Filter pdsfFilter = this.getPooledDSFFilter(config);
            Dictionary<String, String> loadedConfig = this.externalConfigLoader.resolve(config);
            Dictionary<String, String> decryptedConfig = this.decryptor.decrypt(loadedConfig);
            String msg = "Processing config for DataSource {}. ";
            if (pdsfFilter == null) {
                this.LOG.info(msg + "Tracking DSF with filter {}", (Object)DataSourceRegistration.getDSName(config), (Object)dsfFilter);
                tracker = new DataSourceFactoryTracker(this.context, null, dsfFilter, config, decryptedConfig);
            } else {
                this.LOG.info(msg + "Tracking pooling support with filter {}", (Object)DataSourceRegistration.getDSName(config), (Object)pdsfFilter);
                tracker = new PooledDataSourceFactoryTracker(this.context, pdsfFilter, dsfFilter, config, decryptedConfig);
            }
            tracker.open();
            this.trackers.put(pid, tracker);
        }
        catch (InvalidSyntaxException e) {
            this.LOG.warn("Invalid filter for DataSource config from pid " + pid, (Throwable)e);
        }
    }

    private Filter getPooledDSFFilter(Dictionary config) throws ConfigurationException, InvalidSyntaxException {
        String pool = (String)config.remove("pool");
        boolean isXa = this.isXa(config);
        if (pool == null) {
            if (isXa) {
                throw new ConfigurationException(null, "Can not create XA DataSource without pooling.");
            }
            return null;
        }
        ArrayList<String> filterList = new ArrayList<String>();
        filterList.add("objectClass=" + PooledDataSourceFactory.class.getName());
        filterList.add("pool=" + pool);
        filterList.add("xa=" + isXa);
        String filter = this.andFilter(filterList);
        return FrameworkUtil.createFilter((String)filter);
    }

    private boolean isXa(Dictionary config) throws ConfigurationException {
        String xa = (String)config.remove("xa");
        if (xa == null) {
            return false;
        }
        if (!"true".equals(xa)) {
            throw new ConfigurationException(null, "XA can only be set to true");
        }
        return true;
    }

    private Filter getDSFFilter(Dictionary config) throws ConfigurationException, InvalidSyntaxException {
        String driverClass = (String)config.get("osgi.jdbc.driver.class");
        String driverName = (String)config.get("osgi.jdbc.driver.name");
        if (driverClass == null && driverName == null) {
            throw new ConfigurationException(null, "Could not determine driver to use. Specify either osgi.jdbc.driver.class or osgi.jdbc.driver.name");
        }
        ArrayList<String> filterList = new ArrayList<String>();
        filterList.add("objectClass=" + DataSourceFactory.class.getName());
        if (driverClass != null) {
            filterList.add("osgi.jdbc.driver.class=" + driverClass);
        }
        if (driverName != null) {
            filterList.add("osgi.jdbc.driver.name=" + driverName);
        }
        String filter = this.andFilter(filterList);
        return FrameworkUtil.createFilter((String)filter);
    }

    private String andFilter(List<String> filterList) {
        StringBuilder filter = new StringBuilder();
        if (filterList.size() > 1) {
            filter.append("(&");
        }
        for (String filterPart : filterList) {
            filter.append("(" + filterPart + ")");
        }
        if (filterList.size() > 1) {
            filter.append(")");
        }
        return filter.toString();
    }

    public void deleted(String pid) {
        ServiceTracker tracker = this.trackers.get(pid);
        if (tracker != null) {
            tracker.close();
            this.trackers.remove(pid);
        }
    }
}

