/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jdbc.config.impl;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import org.jasypt.encryption.StringEncryptor;
import org.ops4j.pax.jdbc.config.impl.StringEncryptorTracker;

public class Decryptor {
    private static final String ENCRYPTED_PROPERTY_PREFIX = "ENC(";
    private static final String ENCRYPTED_PROPERTY_SUFFIX = ")";
    private static final char ALIAS_SEPARATOR = ',';
    private final StringEncryptorTracker encryptorServiceTracker;

    public Decryptor(StringEncryptorTracker tracker) {
        this.encryptorServiceTracker = tracker;
    }

    public Dictionary<String, String> decrypt(Dictionary config) {
        Hashtable<String, String> decryptedConfig = new Hashtable<String, String>();
        Enumeration e = config.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = String.valueOf(config.get(key));
            if (config.get(key) instanceof String && this.isEncrypted(value)) {
                String plainText = this.decryptValue(value);
                if (plainText == null) continue;
                ((Dictionary)decryptedConfig).put(key, plainText);
                continue;
            }
            ((Dictionary)decryptedConfig).put(key, value);
        }
        return decryptedConfig;
    }

    private String decryptValue(String value) {
        String argument = value.substring(ENCRYPTED_PROPERTY_PREFIX.length(), value.length() - ENCRYPTED_PROPERTY_SUFFIX.length());
        int aliasPos = argument.indexOf(44);
        String cipherText = aliasPos > -1 ? argument.substring(0, aliasPos) : argument;
        String alias = aliasPos > -1 ? argument.substring(aliasPos + 1).trim() : null;
        StringEncryptor encryptor = this.encryptorServiceTracker.getStringEncryptor(alias);
        return encryptor != null ? encryptor.decrypt(cipherText) : null;
    }

    public boolean isEncrypted(String value) {
        return value.startsWith(ENCRYPTED_PROPERTY_PREFIX) && value.endsWith(ENCRYPTED_PROPERTY_SUFFIX);
    }
}

