/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jdbc.config.impl;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalConfigLoader {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalConfigLoader.class);
    private static final String EXTERNAL_PROPERTY_PREFIX = "FILE(";
    private static final String EXTERNAL_PROPERTY_SUFFIX = ")";

    public Dictionary<String, String> resolve(Dictionary config) {
        Hashtable<String, String> loadedConfig = new Hashtable<String, String>();
        Enumeration e = config.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = String.valueOf(config.get(key));
            if (config.get(key) instanceof String && ExternalConfigLoader.isExternal(value)) {
                String argument = value.substring(EXTERNAL_PROPERTY_PREFIX.length(), value.length() - EXTERNAL_PROPERTY_SUFFIX.length());
                String loadedValue = ExternalConfigLoader.readFile(argument, Charset.defaultCharset());
                if (loadedValue == null) continue;
                ((Dictionary)loadedConfig).put(key, loadedValue);
                continue;
            }
            ((Dictionary)loadedConfig).put(key, value);
        }
        return loadedConfig;
    }

    private static String readFile(String path, Charset encoding) {
        try {
            byte[] encoded = Files.readAllBytes(Paths.get(path, new String[0]));
            return new String(encoded, encoding);
        }
        catch (IOException ex) {
            LOG.error("Unable to read external configuration from " + path, (Throwable)ex);
            return null;
        }
    }

    private static boolean isExternal(String value) {
        return value.startsWith(EXTERNAL_PROPERTY_PREFIX) && value.endsWith(EXTERNAL_PROPERTY_SUFFIX);
    }
}

