/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jdbc.config.impl;

import java.util.Dictionary;
import org.ops4j.pax.jdbc.config.impl.DataSourceFactoryTracker;
import org.ops4j.pax.jdbc.config.impl.DataSourceRegistration;
import org.ops4j.pax.jdbc.pool.common.PooledDataSourceFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PooledDataSourceFactoryTracker
extends ServiceTracker {
    private Logger LOG = LoggerFactory.getLogger(DataSourceRegistration.class);
    private Filter dsFilter;
    private Dictionary config;
    private Dictionary decryptedConfig;

    public PooledDataSourceFactoryTracker(BundleContext context, Filter pdsFilter, Filter dsFilter, Dictionary config, Dictionary decryptedConfig) {
        super(context, pdsFilter, null);
        this.dsFilter = dsFilter;
        this.config = config;
        this.decryptedConfig = decryptedConfig;
    }

    public Object addingService(ServiceReference reference) {
        PooledDataSourceFactory pdsf = (PooledDataSourceFactory)super.addingService(reference);
        this.LOG.info("Found pooling support for DataSource {}. Now tracking DataSourceFactory with filter {}", (Object)DataSourceRegistration.getDSName(this.config), (Object)this.dsFilter);
        DataSourceFactoryTracker tracker = new DataSourceFactoryTracker(this.context, pdsf, this.dsFilter, this.config, this.decryptedConfig);
        tracker.open();
        return tracker;
    }

    public void removedService(ServiceReference reference, Object tracked) {
        super.removedService(reference, tracked);
        ((ServiceTracker)tracked).close();
    }
}

