/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jdbc.config.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.jasypt.encryption.StringEncryptor;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringEncryptorTracker
extends ServiceTracker {
    public static final String ALIAS_PROPERTY_KEY = "alias";
    private static final Logger LOG = LoggerFactory.getLogger(StringEncryptorTracker.class);
    private final transient Map<String, StringEncryptor> encryptors = Collections.synchronizedSortedMap(new TreeMap());
    static long ENCRYPTOR_SERVICE_TIMEOUT = 30000L;

    public StringEncryptorTracker(BundleContext context) {
        super(context, StringEncryptor.class.getName(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object addingService(ServiceReference reference) {
        LockObject lockObject;
        String key = this.getAlias(reference);
        StringEncryptor stringEncryptor = (StringEncryptor)super.addingService(reference);
        this.encryptors.put(key, stringEncryptor);
        LockObject lockObject2 = lockObject = LockObject.get(key);
        synchronized (lockObject2) {
            lockObject.notify();
        }
        return stringEncryptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifiedService(ServiceReference reference, Object service) {
        LockObject lockObject;
        String key = this.getAlias(reference);
        StringEncryptor stringEncryptor = (StringEncryptor)service;
        Iterator<Map.Entry<String, StringEncryptor>> it = this.encryptors.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, StringEncryptor> entry = it.next();
            if (!service.equals(entry.getValue())) continue;
            it.remove();
        }
        this.encryptors.put(key, stringEncryptor);
        LockObject lockObject2 = lockObject = LockObject.get(key);
        synchronized (lockObject2) {
            lockObject.notify();
        }
        super.modifiedService(reference, service);
    }

    public void removedService(ServiceReference reference, Object service) {
        String key = this.getAlias(reference);
        this.encryptors.remove(key);
        super.removedService(reference, service);
    }

    private String getAlias(ServiceReference reference) {
        Object aliasProp = reference.getProperty(ALIAS_PROPERTY_KEY);
        return StringEncryptorTracker.getKey(aliasProp != null ? aliasProp.toString() : null);
    }

    private static String getKey(String alias) {
        return alias != null ? "A" + alias : "X";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringEncryptor getStringEncryptor(String alias) {
        String key = StringEncryptorTracker.getKey(alias);
        StringEncryptor encryptor = this.encryptors.get(key);
        if (encryptor == null) {
            LockObject lockObject;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Waiting for StringEncryptor with alias: " + alias);
            }
            LockObject lockObject2 = lockObject = LockObject.get(key);
            synchronized (lockObject2) {
                try {
                    lockObject.wait(ENCRYPTOR_SERVICE_TIMEOUT);
                }
                catch (InterruptedException ex) {
                    LOG.warn("Waiting for String encryptor service is interrupted, alias: " + alias);
                }
            }
            encryptor = this.encryptors.get(key);
            if (encryptor == null) {
                LOG.warn("StringEncryptor service it not available with alias: " + alias);
            }
        }
        return encryptor;
    }

    public void close() {
        super.close();
        this.encryptors.clear();
    }

    private static class LockObject {
        private static final Map<String, LockObject> LOCKS = new HashMap<String, LockObject>();

        private LockObject() {
        }

        static synchronized LockObject get(String key) {
            LockObject lock = LOCKS.get(key);
            if (lock == null) {
                lock = new LockObject();
                LOCKS.put(key, lock);
            }
            return lock;
        }
    }
}

