/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.runner.platform.internal;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.pax.runner.platform.FilePathStrategy;

public class AbsoluteFilePathStrategy
implements FilePathStrategy {
    private static Log LOG = LogFactory.getLog(AbsoluteFilePathStrategy.class);

    public String normalizeAsPath(File file) {
        return file.getAbsolutePath();
    }

    public String normalizeAsUrl(File file) {
        try {
            return file.toURL().toExternalForm();
        }
        catch (MalformedURLException e) {
            return "file:/" + file.getAbsolutePath().replace(File.separatorChar, '/');
        }
    }

    public String normalizeAsUrl(URL url) {
        return url.toExternalForm();
    }
}

