/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.runner.platform.internal;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.runner.platform.BundleReference;

public class LocalBundleReference
implements BundleReference {
    private final BundleReference m_bundleReference;
    private final File m_file;

    public LocalBundleReference(BundleReference bundleReference, File file) {
        NullArgumentException.validateNotNull(bundleReference, "Bundle reference");
        NullArgumentException.validateNotNull(file, "File");
        this.m_bundleReference = bundleReference;
        this.m_file = file;
    }

    public String getName() {
        return this.m_bundleReference.getName();
    }

    public URL getURL() {
        try {
            return this.m_file.toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public Integer getStartLevel() {
        return this.m_bundleReference.getStartLevel();
    }

    public Boolean shouldStart() {
        return this.m_bundleReference.shouldStart();
    }

    public Boolean shouldUpdate() {
        return this.m_bundleReference.shouldUpdate();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalBundleReference that = (LocalBundleReference)o;
        return this.m_file.equals(that.m_file);
    }

    public int hashCode() {
        return this.m_file.hashCode();
    }

    public String toString() {
        return "{" + "file=" + this.m_file + ",reference=" + this.m_bundleReference + "}";
    }
}

