/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.scanner.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.scanner.ProvisionService;
import org.ops4j.pax.scanner.Scanner;
import org.ops4j.pax.scanner.internal.ProvisionServiceImpl;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.startlevel.StartLevel;
import org.osgi.util.tracker.ServiceTracker;

public final class Activator
implements BundleActivator {
    private static final Log LOGGER = LogFactory.getLog(Activator.class);
    private BundleContext m_bundleContext;
    private ProvisionServiceImpl m_provisionService;
    private ServiceTracker m_serviceTracker;
    private ServiceRegistration m_provisionServiceReg;

    public void start(BundleContext bundleContext) {
        NullArgumentException.validateNotNull(bundleContext, "Bundle context");
        this.m_bundleContext = bundleContext;
        this.registerProvisionService();
        this.trackStartLevelService();
        this.trackScanners();
        LOGGER.debug((Object)"Provisioning service started");
    }

    public void stop(BundleContext bundleContext) {
        NullArgumentException.validateNotNull(bundleContext, "Bundle context");
        if (this.m_serviceTracker != null) {
            this.m_serviceTracker.close();
            this.m_serviceTracker = null;
        }
        if (this.m_provisionServiceReg != null) {
            this.m_provisionServiceReg.unregister();
            this.m_provisionServiceReg = null;
            this.m_provisionService = null;
        }
        this.m_bundleContext = null;
        LOGGER.debug((Object)"Provisioning service stopped");
    }

    private void trackScanners() {
        this.m_serviceTracker = new ServiceTracker(this.m_bundleContext, Scanner.class.getName(), null){

            public Object addingService(ServiceReference serviceReference) {
                NullArgumentException.validateNotNull(serviceReference, "Service reference");
                LOGGER.debug((Object)("Scanner available [" + serviceReference + "]"));
                Object schema = serviceReference.getProperty("provision.schema");
                Scanner scanner = null;
                if (schema != null && schema instanceof String && ((String)schema).trim().length() > 0 && (scanner = (Scanner)super.addingService(serviceReference)) != null) {
                    Activator.this.m_provisionService.addScanner(scanner, (String)schema);
                }
                return scanner;
            }

            public void removedService(ServiceReference serviceReference, Object object) {
                LOGGER.debug((Object)("Scanner removed [" + serviceReference + "]"));
                super.removedService(serviceReference, object);
                if (!(object instanceof Scanner)) {
                    throw new IllegalArgumentException("Invalid tracked object [" + object.getClass() + "]. Expected an " + Scanner.class.getName());
                }
                Activator.this.m_provisionService.removeScanner((Scanner)object);
            }
        };
        this.m_serviceTracker.open();
    }

    private void registerProvisionService() {
        this.m_provisionService = new ProvisionServiceImpl(this.m_bundleContext);
        this.m_provisionServiceReg = this.m_bundleContext.registerService(ProvisionService.class.getName(), (Object)this.m_provisionService, null);
    }

    private void trackStartLevelService() {
        this.m_serviceTracker = new ServiceTracker(this.m_bundleContext, StartLevel.class.getName(), null){

            public Object addingService(ServiceReference serviceReference) {
                NullArgumentException.validateNotNull(serviceReference, "Service reference");
                LOGGER.debug((Object)("Start Level service available [" + serviceReference + "]"));
                StartLevel startLevel = (StartLevel)super.addingService(serviceReference);
                if (startLevel != null) {
                    Activator.this.m_provisionService.setStartLevelService(startLevel);
                }
                return startLevel;
            }
        };
        this.m_serviceTracker.open();
    }
}

