/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.url.obr.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.net.URLUtils;
import org.ops4j.pax.swissbox.tracker.ReplaceableService;
import org.ops4j.pax.url.obr.internal.Configuration;
import org.ops4j.pax.url.obr.internal.FilterValidator;
import org.ops4j.pax.url.obr.internal.Parser;
import org.osgi.service.obr.RepositoryAdmin;
import org.osgi.service.obr.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Connection
extends URLConnection {
    private static final Log LOG = LogFactory.getLog(Connection.class);
    private Parser m_parser;
    private final Configuration m_configuration;
    private final ReplaceableService<RepositoryAdmin> m_replaceableService;

    public Connection(URL url, Configuration configuration, ReplaceableService<RepositoryAdmin> replaceableService, FilterValidator filterValidator) throws MalformedURLException {
        super(url);
        NullArgumentException.validateNotNull(url, "URL cannot be null");
        NullArgumentException.validateNotNull(configuration, "Service configuration");
        NullArgumentException.validateNotNull(replaceableService, "No Replaceable Service available");
        this.m_configuration = configuration;
        this.m_replaceableService = replaceableService;
        this.m_parser = new Parser(url.getPath(), filterValidator);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.connect();
        LOG.debug((Object)("Discover resources for filter [" + this.m_parser.getFilter() + "]"));
        this.m_replaceableService.start();
        RepositoryAdmin repositoryAdmin = this.m_replaceableService.getService();
        if (repositoryAdmin == null) {
            throw new IllegalStateException("No RepositoryAdmin Service available");
        }
        Resource[] resources = repositoryAdmin.discoverResources(this.m_parser.getFilter());
        if (resources.length == 0) {
            throw new IOException("No resource found for provided filter [" + this.m_parser.getFilter() + "]");
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"Found resources:");
            for (Resource resource : resources) {
                StringBuilder builder = new StringBuilder().append("id=").append(resource.getId()).append(",sn=").append(resource.getSymbolicName()).append(",v=").append(resource.getVersion()).append(",url=").append(resource.getURL());
                LOG.trace((Object)("  " + builder.toString()));
            }
        }
        return URLUtils.prepareInputStream(resources[0].getURL(), this.m_configuration.getCertificateCheck() == false);
    }

    @Override
    public void connect() {
    }
}

