/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.cache;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.cache.BundleCache;
import org.apache.felix.framework.cache.BundleRevision;
import org.apache.felix.framework.cache.DirectoryRevision;
import org.apache.felix.framework.cache.JarRevision;
import org.apache.felix.framework.util.ObjectInputStreamX;
import org.apache.felix.moduleloader.IModule;
import org.osgi.framework.BundleActivator;

public class BundleArchive {
    public static final transient String FILE_PROTOCOL = "file:";
    public static final transient String REFERENCE_PROTOCOL = "reference:";
    public static final transient String INPUTSTREAM_PROTOCOL = "inputstream:";
    private static final transient String BUNDLE_ID_FILE = "bundle.id";
    private static final transient String BUNDLE_LOCATION_FILE = "bundle.location";
    private static final transient String CURRENT_LOCATION_FILE = "current.location";
    private static final transient String REVISION_LOCATION_FILE = "revision.location";
    private static final transient String BUNDLE_STATE_FILE = "bundle.state";
    private static final transient String BUNDLE_START_LEVEL_FILE = "bundle.startlevel";
    private static final transient String REFRESH_COUNTER_FILE = "refresh.counter";
    private static final transient String BUNDLE_ACTIVATOR_FILE = "bundle.activator";
    private static final transient String BUNDLE_LASTMODIFIED_FILE = "bundle.lastmodified";
    private static final transient String REVISION_DIRECTORY = "version";
    private static final transient String DATA_DIRECTORY = "data";
    private static final transient String ACTIVE_STATE = "active";
    private static final transient String INSTALLED_STATE = "installed";
    private static final transient String UNINSTALLED_STATE = "uninstalled";
    private Logger m_logger = null;
    private long m_id = -1L;
    private File m_archiveRootDir = null;
    private String m_originalLocation = null;
    private String m_currentLocation = null;
    private int m_persistentState = -1;
    private int m_startLevel = -1;
    private long m_lastModified = -1L;
    private BundleRevision[] m_revisions = null;
    private long m_refreshCount = -1L;

    public BundleArchive() {
    }

    public BundleArchive(Logger logger, File archiveRootDir, long id, String location, InputStream is) throws Exception {
        this.m_logger = logger;
        this.m_archiveRootDir = archiveRootDir;
        this.m_id = id;
        if (this.m_id <= 0L) {
            throw new IllegalArgumentException("Bundle ID cannot be less than or equal to zero.");
        }
        this.m_originalLocation = location;
        this.initialize();
        this.revise(this.m_originalLocation, is);
    }

    public BundleArchive(Logger logger, File archiveRootDir) throws Exception {
        this.m_logger = logger;
        this.m_archiveRootDir = archiveRootDir;
        int revisionCount = 0;
        while (true) {
            File revisionRootDir = new File(this.m_archiveRootDir, REVISION_DIRECTORY + this.getRefreshCount() + "." + revisionCount);
            if (!BundleCache.getSecureAction().fileExists(revisionRootDir)) break;
            ++revisionCount;
        }
        if (revisionCount > 1) {
            this.m_revisions = new BundleRevision[revisionCount - 1];
        }
        this.revise(this.getRevisionLocation(revisionCount - 1), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized long getId() throws Exception {
        InputStream is;
        block8: {
            if (this.m_id > 0L) {
                return this.m_id;
            }
            is = null;
            BufferedReader br = null;
            try {
                try {
                    is = BundleCache.getSecureAction().getFileInputStream(new File(this.m_archiveRootDir, BUNDLE_ID_FILE));
                    br = new BufferedReader(new InputStreamReader(is));
                    this.m_id = Long.parseLong(br.readLine());
                }
                catch (FileNotFoundException ex) {
                    this.m_id = Long.parseLong(this.m_archiveRootDir.getName().substring("bundle".length()));
                    Object var5_4 = null;
                    if (br != null) {
                        br.close();
                    }
                    if (is == null) return this.m_id;
                    is.close();
                    return this.m_id;
                }
                Object var5_3 = null;
                if (br == null) break block8;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (br != null) {
                    br.close();
                }
                if (is == null) throw throwable;
                is.close();
                throw throwable;
            }
            br.close();
        }
        if (is == null) return this.m_id;
        is.close();
        return this.m_id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getLocation() throws Exception {
        String string;
        InputStream is;
        block5: {
            if (this.m_originalLocation != null) {
                return this.m_originalLocation;
            }
            is = null;
            BufferedReader br = null;
            try {
                is = BundleCache.getSecureAction().getFileInputStream(new File(this.m_archiveRootDir, BUNDLE_LOCATION_FILE));
                br = new BufferedReader(new InputStreamReader(is));
                string = this.m_originalLocation = br.readLine();
                Object var5_4 = null;
                if (br == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var5_5 = null;
                    if (br != null) {
                        br.close();
                    }
                    if (is == null) break block6;
                    is.close();
                }
                throw throwable;
            }
            br.close();
        }
        if (is != null) {
            is.close();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int getPersistentState() throws Exception {
        int n;
        InputStream is;
        block6: {
            if (this.m_persistentState >= 0) {
                return this.m_persistentState;
            }
            File stateFile = new File(this.m_archiveRootDir, BUNDLE_STATE_FILE);
            if (!BundleCache.getSecureAction().fileExists(stateFile)) {
                return 2;
            }
            is = null;
            BufferedReader br = null;
            try {
                is = BundleCache.getSecureAction().getFileInputStream(stateFile);
                br = new BufferedReader(new InputStreamReader(is));
                String s = br.readLine();
                this.m_persistentState = s.equals(ACTIVE_STATE) ? 32 : (s.equals(UNINSTALLED_STATE) ? 1 : 2);
                n = this.m_persistentState;
                Object var7_6 = null;
                if (br == null) break block6;
            }
            catch (Throwable throwable) {
                block7: {
                    Object var7_7 = null;
                    if (br != null) {
                        br.close();
                    }
                    if (is == null) break block7;
                    is.close();
                }
                throw throwable;
            }
            br.close();
        }
        if (is != null) {
            is.close();
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void setPersistentState(int state) throws Exception {
        OutputStream os;
        block10: {
            os = null;
            BufferedWriter bw = null;
            try {
                try {
                    os = BundleCache.getSecureAction().getFileOutputStream(new File(this.m_archiveRootDir, BUNDLE_STATE_FILE));
                    bw = new BufferedWriter(new OutputStreamWriter(os));
                    String s = null;
                    switch (state) {
                        case 32: {
                            s = ACTIVE_STATE;
                            break;
                        }
                        case 1: {
                            s = UNINSTALLED_STATE;
                            break;
                        }
                        default: {
                            s = INSTALLED_STATE;
                        }
                    }
                    bw.write(s, 0, s.length());
                    this.m_persistentState = state;
                }
                catch (IOException ex) {
                    this.m_logger.log(1, this.getClass().getName() + ": Unable to record state - " + ex);
                    throw ex;
                }
                Object var6_6 = null;
                if (bw == null) break block10;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (bw != null) {
                    bw.close();
                }
                if (os == null) throw throwable;
                os.close();
                throw throwable;
            }
            bw.close();
        }
        if (os == null) return;
        os.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int getStartLevel() throws Exception {
        int n;
        InputStream is;
        block6: {
            if (this.m_startLevel >= 0) {
                return this.m_startLevel;
            }
            File levelFile = new File(this.m_archiveRootDir, BUNDLE_START_LEVEL_FILE);
            if (!BundleCache.getSecureAction().fileExists(levelFile)) {
                return -1;
            }
            is = null;
            BufferedReader br = null;
            try {
                is = BundleCache.getSecureAction().getFileInputStream(levelFile);
                br = new BufferedReader(new InputStreamReader(is));
                n = this.m_startLevel = Integer.parseInt(br.readLine());
                Object var6_5 = null;
                if (br == null) break block6;
            }
            catch (Throwable throwable) {
                block7: {
                    Object var6_6 = null;
                    if (br != null) {
                        br.close();
                    }
                    if (is == null) break block7;
                    is.close();
                }
                throw throwable;
            }
            br.close();
        }
        if (is != null) {
            is.close();
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void setStartLevel(int level) throws Exception {
        OutputStream os;
        block6: {
            os = null;
            BufferedWriter bw = null;
            try {
                try {
                    os = BundleCache.getSecureAction().getFileOutputStream(new File(this.m_archiveRootDir, BUNDLE_START_LEVEL_FILE));
                    bw = new BufferedWriter(new OutputStreamWriter(os));
                    String s = Integer.toString(level);
                    bw.write(s, 0, s.length());
                    this.m_startLevel = level;
                }
                catch (IOException ex) {
                    this.m_logger.log(1, this.getClass().getName() + ": Unable to record start level - " + ex);
                    throw ex;
                }
                Object var6_6 = null;
                if (bw == null) break block6;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (bw != null) {
                    bw.close();
                }
                if (os == null) throw throwable;
                os.close();
                throw throwable;
            }
            bw.close();
        }
        if (os == null) return;
        os.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long getLastModified() throws Exception {
        long l;
        InputStream is;
        block6: {
            if (this.m_lastModified >= 0L) {
                return this.m_lastModified;
            }
            File lastModFile = new File(this.m_archiveRootDir, BUNDLE_LASTMODIFIED_FILE);
            if (!BundleCache.getSecureAction().fileExists(lastModFile)) {
                return 0L;
            }
            is = null;
            BufferedReader br = null;
            try {
                is = BundleCache.getSecureAction().getFileInputStream(lastModFile);
                br = new BufferedReader(new InputStreamReader(is));
                l = this.m_lastModified = Long.parseLong(br.readLine());
                Object var7_5 = null;
                if (br == null) break block6;
            }
            catch (Throwable throwable) {
                block7: {
                    Object var7_6 = null;
                    if (br != null) {
                        br.close();
                    }
                    if (is == null) break block7;
                    is.close();
                }
                throw throwable;
            }
            br.close();
        }
        if (is != null) {
            is.close();
        }
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void setLastModified(long lastModified) throws Exception {
        OutputStream os;
        block6: {
            os = null;
            BufferedWriter bw = null;
            try {
                try {
                    os = BundleCache.getSecureAction().getFileOutputStream(new File(this.m_archiveRootDir, BUNDLE_LASTMODIFIED_FILE));
                    bw = new BufferedWriter(new OutputStreamWriter(os));
                    String s = Long.toString(lastModified);
                    bw.write(s, 0, s.length());
                    this.m_lastModified = lastModified;
                }
                catch (IOException ex) {
                    this.m_logger.log(1, this.getClass().getName() + ": Unable to record last modification time - " + ex);
                    throw ex;
                }
                Object var7_6 = null;
                if (bw == null) break block6;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (bw != null) {
                    bw.close();
                }
                if (os == null) throw throwable;
                os.close();
                throw throwable;
            }
            bw.close();
        }
        if (os == null) return;
        os.close();
    }

    public synchronized File getDataFile(String fileName) throws Exception {
        if (fileName.length() > 0 && fileName.charAt(0) == File.separatorChar) {
            throw new IllegalArgumentException("The data file path must be relative, not absolute.");
        }
        if (fileName.indexOf("..") >= 0) {
            throw new IllegalArgumentException("The data file path cannot contain a reference to the \"..\" directory.");
        }
        File dataDir = new File(this.m_archiveRootDir, DATA_DIRECTORY);
        if (!BundleCache.getSecureAction().fileExists(dataDir) && !BundleCache.getSecureAction().mkdir(dataDir)) {
            throw new IOException("Unable to create bundle data directory.");
        }
        return new File(dataDir, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized BundleActivator getActivator(IModule module) throws Exception {
        BundleActivator bundleActivator;
        InputStream is;
        block6: {
            File activatorFile = new File(this.m_archiveRootDir, BUNDLE_ACTIVATOR_FILE);
            if (!BundleCache.getSecureAction().fileExists(activatorFile)) {
                return null;
            }
            is = null;
            ObjectInputStream ois = null;
            try {
                is = BundleCache.getSecureAction().getFileInputStream(activatorFile);
                ois = new ObjectInputStreamX(is, module);
                Object o = ois.readObject();
                bundleActivator = (BundleActivator)o;
                Object var8_8 = null;
                if (ois == null) break block6;
            }
            catch (Exception ex) {
                block7: {
                    try {
                        this.m_logger.log(1, this.getClass().getName() + ": Trying to deserialize - " + ex);
                        Object var8_9 = null;
                        if (ois == null) break block7;
                    }
                    catch (Throwable throwable) {
                        Object var8_10 = null;
                        if (ois != null) {
                            ois.close();
                        }
                        if (is == null) throw throwable;
                        is.close();
                        throw throwable;
                    }
                    ois.close();
                }
                if (is == null) return null;
                is.close();
                return null;
            }
            ois.close();
        }
        if (is == null) return bundleActivator;
        is.close();
        return bundleActivator;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void setActivator(Object obj) throws Exception {
        OutputStream os;
        block7: {
            if (!(obj instanceof Serializable)) {
                return;
            }
            os = null;
            ObjectOutputStream oos = null;
            try {
                try {
                    os = BundleCache.getSecureAction().getFileOutputStream(new File(this.m_archiveRootDir, BUNDLE_ACTIVATOR_FILE));
                    oos = new ObjectOutputStream(os);
                    oos.writeObject(obj);
                }
                catch (IOException ex) {
                    this.m_logger.log(1, this.getClass().getName() + ": Unable to serialize activator - " + ex);
                    throw ex;
                }
                Object var6_4 = null;
                if (oos == null) break block7;
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                if (oos != null) {
                    oos.close();
                }
                if (os == null) throw throwable;
                os.close();
                throw throwable;
            }
            oos.close();
        }
        if (os == null) return;
        os.close();
    }

    public synchronized int getRevisionCount() {
        return this.m_revisions == null ? 0 : this.m_revisions.length;
    }

    public synchronized BundleRevision getRevision(int i) {
        if (i >= 0 && i < this.getRevisionCount()) {
            return this.m_revisions[i];
        }
        return null;
    }

    public synchronized void revise(String location, InputStream is) throws Exception {
        BundleRevision revision;
        if (is != null) {
            location = INPUTSTREAM_PROTOCOL;
        }
        if ((revision = this.createRevisionFromLocation(location, is)) == null) {
            throw new Exception("Unable to revise archive.");
        }
        this.setRevisionLocation(location, this.m_revisions == null ? 0 : this.m_revisions.length);
        if (this.m_revisions == null) {
            this.m_revisions = new BundleRevision[]{revision};
        } else {
            BundleRevision[] tmp = new BundleRevision[this.m_revisions.length + 1];
            System.arraycopy(this.m_revisions, 0, tmp, 0, this.m_revisions.length);
            tmp[this.m_revisions.length] = revision;
            this.m_revisions = tmp;
        }
    }

    public synchronized boolean undoRevise() throws Exception {
        if (this.getRevisionCount() <= 1) {
            return false;
        }
        String location = this.getRevisionLocation(this.m_revisions.length - 2);
        try {
            this.m_revisions[this.m_revisions.length - 1].dispose();
        }
        catch (Exception ex) {
            this.m_logger.log(1, this.getClass().getName() + ": Unable to dispose latest revision", ex);
        }
        File revisionDir = new File(this.m_archiveRootDir, REVISION_DIRECTORY + this.getRefreshCount() + "." + (this.m_revisions.length - 1));
        if (BundleCache.getSecureAction().fileExists(revisionDir)) {
            BundleCache.deleteDirectoryTree(revisionDir);
        }
        BundleRevision[] tmp = new BundleRevision[this.m_revisions.length - 1];
        System.arraycopy(this.m_revisions, 0, tmp, 0, this.m_revisions.length - 1);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized String getRevisionLocation(int revision) throws Exception {
        String string;
        InputStream is;
        block4: {
            is = null;
            BufferedReader br = null;
            try {
                is = BundleCache.getSecureAction().getFileInputStream(new File(new File(this.m_archiveRootDir, REVISION_DIRECTORY + this.getRefreshCount() + "." + revision), REVISION_LOCATION_FILE));
                br = new BufferedReader(new InputStreamReader(is));
                string = br.readLine();
                Object var6_5 = null;
                if (br == null) break block4;
            }
            catch (Throwable throwable) {
                block5: {
                    Object var6_6 = null;
                    if (br != null) {
                        br.close();
                    }
                    if (is == null) break block5;
                    is.close();
                }
                throw throwable;
            }
            br.close();
        }
        if (is != null) {
            is.close();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void setRevisionLocation(String location, int revision) throws Exception {
        OutputStream os;
        block5: {
            os = null;
            BufferedWriter bw = null;
            try {
                os = BundleCache.getSecureAction().getFileOutputStream(new File(new File(this.m_archiveRootDir, REVISION_DIRECTORY + this.getRefreshCount() + "." + revision), REVISION_LOCATION_FILE));
                bw = new BufferedWriter(new OutputStreamWriter(os));
                bw.write(location, 0, location.length());
                Object var6_5 = null;
                if (bw == null) break block5;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (bw != null) {
                    bw.close();
                }
                if (os != null) {
                    os.close();
                }
                throw throwable;
            }
            bw.close();
        }
        if (os != null) {
            os.close();
        }
    }

    public synchronized void purge() throws Exception {
        long refreshCount = this.getRefreshCount();
        int count = this.getRevisionCount();
        File revisionDir = null;
        for (int i = 0; i < count - 1; ++i) {
            if (this.m_revisions[i] != null) {
                this.m_revisions[i].dispose();
            }
            revisionDir = new File(this.m_archiveRootDir, REVISION_DIRECTORY + refreshCount + "." + i);
            if (!BundleCache.getSecureAction().fileExists(revisionDir)) continue;
            BundleCache.deleteDirectoryTree(revisionDir);
        }
        this.m_revisions[count - 1].dispose();
        String location = this.getRevisionLocation(count - 1);
        this.setRefreshCount(refreshCount + 1L);
        File currentDir = new File(this.m_archiveRootDir, REVISION_DIRECTORY + (refreshCount + 1L) + ".0");
        revisionDir = new File(this.m_archiveRootDir, REVISION_DIRECTORY + refreshCount + "." + (count - 1));
        BundleCache.getSecureAction().renameFile(revisionDir, currentDir);
        this.m_revisions = null;
        BundleRevision revision = this.createRevisionFromLocation(location, null);
        this.m_revisions = new BundleRevision[]{revision};
    }

    void dispose() throws Exception {
        if (!BundleCache.deleteDirectoryTree(this.m_archiveRootDir)) {
            this.m_logger.log(1, this.getClass().getName() + ": Unable to delete archive directory - " + this.m_archiveRootDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initialize() throws Exception {
        BufferedWriter bw;
        OutputStream os;
        block8: {
            block6: {
                block7: {
                    os = null;
                    bw = null;
                    try {
                        if (BundleCache.getSecureAction().fileExists(this.m_archiveRootDir)) {
                            Object var4_3 = null;
                            if (bw == null) break block6;
                            break block7;
                        }
                        if (!BundleCache.getSecureAction().mkdir(this.m_archiveRootDir)) {
                            this.m_logger.log(1, this.getClass().getName() + ": Unable to create archive directory.");
                            throw new IOException("Unable to create archive directory.");
                        }
                        os = BundleCache.getSecureAction().getFileOutputStream(new File(this.m_archiveRootDir, BUNDLE_ID_FILE));
                        bw = new BufferedWriter(new OutputStreamWriter(os));
                        bw.write(Long.toString(this.m_id), 0, Long.toString(this.m_id).length());
                        bw.close();
                        os.close();
                        os = BundleCache.getSecureAction().getFileOutputStream(new File(this.m_archiveRootDir, BUNDLE_LOCATION_FILE));
                        bw = new BufferedWriter(new OutputStreamWriter(os));
                        bw.write(this.m_originalLocation, 0, this.m_originalLocation.length());
                        break block8;
                    }
                    catch (Throwable throwable) {
                        Object var4_5 = null;
                        if (bw != null) {
                            bw.close();
                        }
                        if (os == null) throw throwable;
                        os.close();
                        throw throwable;
                    }
                }
                bw.close();
            }
            if (os == null) return;
            os.close();
            return;
        }
        Object var4_4 = null;
        if (bw != null) {
            bw.close();
        }
        if (os == null) return;
        os.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCurrentLocation() throws Exception {
        String string;
        InputStream is;
        block8: {
            if (this.m_currentLocation != null) {
                return this.m_currentLocation;
            }
            is = null;
            BufferedReader br = null;
            try {
                is = BundleCache.getSecureAction().getFileInputStream(new File(this.m_archiveRootDir, CURRENT_LOCATION_FILE));
                br = new BufferedReader(new InputStreamReader(is));
                string = this.m_currentLocation = br.readLine();
                Object var6_5 = null;
                if (br == null) break block8;
            }
            catch (FileNotFoundException ex) {
                String string2;
                block9: {
                    try {
                        string2 = this.getLocation();
                        Object var6_6 = null;
                        if (br == null) break block9;
                    }
                    catch (Throwable throwable) {
                        block10: {
                            Object var6_7 = null;
                            if (br != null) {
                                br.close();
                            }
                            if (is == null) break block10;
                            is.close();
                        }
                        throw throwable;
                    }
                    br.close();
                }
                if (is != null) {
                    is.close();
                }
                return string2;
            }
            br.close();
        }
        if (is != null) {
            is.close();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCurrentLocation(String location) throws Exception {
        OutputStream os;
        block5: {
            os = null;
            BufferedWriter bw = null;
            try {
                os = BundleCache.getSecureAction().getFileOutputStream(new File(this.m_archiveRootDir, CURRENT_LOCATION_FILE));
                bw = new BufferedWriter(new OutputStreamWriter(os));
                bw.write(location, 0, location.length());
                this.m_currentLocation = location;
                Object var5_4 = null;
                if (bw == null) break block5;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (bw != null) {
                    bw.close();
                }
                if (os != null) {
                    os.close();
                }
                throw throwable;
            }
            bw.close();
        }
        if (os != null) {
            os.close();
        }
    }

    private BundleRevision createRevisionFromLocation(String location, InputStream is) throws Exception {
        File revisionRootDir = new File(this.m_archiveRootDir, REVISION_DIRECTORY + this.getRefreshCount() + "." + this.getRevisionCount());
        BundleRevision result = null;
        try {
            if (location != null && location.startsWith(REFERENCE_PROTOCOL)) {
                if (!(location = location.substring(REFERENCE_PROTOCOL.length())).startsWith(FILE_PROTOCOL)) {
                    throw new IOException("Reference URLs can only be files: " + location);
                }
                File file = new File(location.substring(FILE_PROTOCOL.length()));
                if (!BundleCache.getSecureAction().fileExists(file)) {
                    throw new IOException("Referenced file does not exist: " + file);
                }
                result = BundleCache.getSecureAction().isFileDirectory(file) ? new DirectoryRevision(this.m_logger, revisionRootDir, location) : new JarRevision(this.m_logger, revisionRootDir, location, true);
            } else {
                result = location.startsWith(INPUTSTREAM_PROTOCOL) ? new JarRevision(this.m_logger, revisionRootDir, location, false, is) : new JarRevision(this.m_logger, revisionRootDir, location, false);
            }
        }
        catch (Exception ex) {
            if (BundleCache.getSecureAction().fileExists(revisionRootDir) && !BundleCache.deleteDirectoryTree(revisionRootDir)) {
                this.m_logger.log(1, this.getClass().getName() + ": Unable to delete revision directory - " + revisionRootDir);
            }
            throw ex;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getRefreshCount() throws Exception {
        long l;
        InputStream is;
        block6: {
            if (this.m_refreshCount >= 0L) {
                return this.m_refreshCount;
            }
            File counterFile = new File(this.m_archiveRootDir, REFRESH_COUNTER_FILE);
            if (!BundleCache.getSecureAction().fileExists(counterFile)) {
                return 0L;
            }
            is = null;
            BufferedReader br = null;
            try {
                long counter;
                is = BundleCache.getSecureAction().getFileInputStream(counterFile);
                br = new BufferedReader(new InputStreamReader(is));
                l = counter = Long.parseLong(br.readLine());
                Object var9_6 = null;
                if (br == null) break block6;
            }
            catch (Throwable throwable) {
                block7: {
                    Object var9_7 = null;
                    if (br != null) {
                        br.close();
                    }
                    if (is == null) break block7;
                    is.close();
                }
                throw throwable;
            }
            br.close();
        }
        if (is != null) {
            is.close();
        }
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setRefreshCount(long counter) throws Exception {
        OutputStream os;
        block6: {
            File counterFile = new File(this.m_archiveRootDir, REFRESH_COUNTER_FILE);
            os = null;
            BufferedWriter bw = null;
            try {
                try {
                    os = BundleCache.getSecureAction().getFileOutputStream(counterFile);
                    bw = new BufferedWriter(new OutputStreamWriter(os));
                    String s = Long.toString(counter);
                    bw.write(s, 0, s.length());
                    this.m_refreshCount = counter;
                }
                catch (IOException ex) {
                    this.m_logger.log(1, this.getClass().getName() + ": Unable to write refresh counter: " + ex);
                    throw ex;
                }
                Object var8_7 = null;
                if (bw == null) break block6;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (bw != null) {
                    bw.close();
                }
                if (os == null) throw throwable;
                os.close();
                throw throwable;
            }
            bw.close();
        }
        if (os == null) return;
        os.close();
    }
}

