/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.moduleloader;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.apache.felix.moduleloader.IContent;

public class DirectoryContent
implements IContent {
    private static final int BUFSIZE = 4096;
    private File m_dir = null;
    private boolean m_opened = false;

    public DirectoryContent(File dir) {
        this.m_dir = dir;
    }

    protected void finalize() {
    }

    public void open() {
        this.m_opened = true;
    }

    public synchronized void close() {
        this.m_opened = false;
    }

    public synchronized boolean hasEntry(String name) throws IllegalStateException {
        if (!this.m_opened) {
            throw new IllegalStateException("DirectoryContent is not open");
        }
        if (name.length() > 0 && name.charAt(0) == '/') {
            name = name.substring(1);
        }
        return new File(this.m_dir, name).exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized byte[] getEntry(String name) throws IllegalStateException {
        if (!this.m_opened) {
            throw new IllegalStateException("DirectoryContent is not open");
        }
        if (name.length() > 0 && name.charAt(0) == '/') {
            name = name.substring(1);
        }
        BufferedInputStream is = null;
        ByteArrayOutputStream baos = null;
        is = new BufferedInputStream(new FileInputStream(new File(this.m_dir, name)));
        baos = new ByteArrayOutputStream(4096);
        byte[] buf = new byte[4096];
        int n = 0;
        while ((n = ((InputStream)is).read(buf, 0, buf.length)) >= 0) {
            baos.write(buf, 0, n);
        }
        byte[] byArray = baos.toByteArray();
        Object var8_9 = null;
        try {
            if (baos != null) {
                baos.close();
            }
        }
        catch (Exception ex2) {
            // empty catch block
        }
        try {
            if (is != null) {
                ((InputStream)is).close();
            }
        }
        catch (Exception ex2) {
            // empty catch block
        }
        return byArray;
        catch (Exception ex) {
            byte[] byArray2;
            try {
                byArray2 = null;
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                try {
                    if (baos != null) {
                        baos.close();
                    }
                }
                catch (Exception ex2) {
                    // empty catch block
                }
                try {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
                catch (Exception ex2) {}
                throw throwable;
            }
            try {
                if (baos != null) {
                    baos.close();
                }
            }
            catch (Exception ex2) {
                // empty catch block
            }
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (Exception ex2) {
                // empty catch block
            }
            return byArray2;
        }
    }

    public synchronized InputStream getEntryAsStream(String name) throws IllegalStateException, IOException {
        if (!this.m_opened) {
            throw new IllegalStateException("DirectoryContent is not open");
        }
        if (name.length() > 0 && name.charAt(0) == '/') {
            name = name.substring(1);
        }
        return new FileInputStream(new File(this.m_dir, name));
    }

    public synchronized Enumeration getEntries() {
        if (!this.m_opened) {
            throw new IllegalStateException("JarContent is not open");
        }
        EntriesEnumeration e = new EntriesEnumeration(this.m_dir);
        return e.hasMoreElements() ? e : null;
    }

    public String toString() {
        return "DIRECTORY " + this.m_dir;
    }

    private static class EntriesEnumeration
    implements Enumeration {
        private File m_dir = null;
        private File[] m_children = null;
        private int m_counter = 0;

        public EntriesEnumeration(File dir) {
            this.m_dir = dir;
            this.m_children = this.listFilesRecursive(this.m_dir);
        }

        public boolean hasMoreElements() {
            return this.m_children != null && this.m_counter < this.m_children.length;
        }

        public Object nextElement() {
            if (this.m_children == null || this.m_counter >= this.m_children.length) {
                throw new NoSuchElementException("No more entry paths.");
            }
            String abs = this.m_children[this.m_counter].getAbsolutePath().replace(File.separatorChar, '/');
            StringBuffer sb = new StringBuffer(abs);
            sb.delete(0, this.m_dir.getAbsolutePath().length() + 1);
            if (this.m_children[this.m_counter].isDirectory()) {
                sb.append('/');
            }
            ++this.m_counter;
            return sb.toString();
        }

        public File[] listFilesRecursive(File dir) {
            File[] children;
            File[] combined = children = dir.listFiles();
            for (int i = 0; i < children.length; ++i) {
                File[] grandchildren;
                if (!children[i].isDirectory() || (grandchildren = this.listFilesRecursive(children[i])).length <= 0) continue;
                File[] tmp = new File[combined.length + grandchildren.length];
                System.arraycopy(combined, 0, tmp, 0, combined.length);
                System.arraycopy(grandchildren, 0, tmp, combined.length, grandchildren.length);
                combined = tmp;
            }
            return combined;
        }
    }
}

