/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.url.assembly.internal;

import java.net.URL;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.url.assembly.internal.Resource;

class JarResource
implements Resource {
    private final URL m_url;

    JarResource(URL url) {
        NullArgumentException.validateNotNull(url, "Resource url");
        if (!"jar".equals(url.getProtocol()) && !url.toExternalForm().contains("!/")) {
            throw new IllegalArgumentException(String.format("URL [%s] is not referring to a jar resource", url));
        }
        this.m_url = url;
    }

    public String path() {
        String externalForm = this.m_url.toExternalForm();
        return externalForm.substring(externalForm.lastIndexOf("!/") + 2);
    }

    public URL url() {
        return this.m_url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Resource)) {
            return false;
        }
        Resource that = (Resource)o;
        return this.path().equals(that.path());
    }

    public int hashCode() {
        return this.path().hashCode();
    }

    public String toString() {
        return this.path();
    }
}

