/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.url.dir.internal.bundle;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.ops4j.io.StreamUtils;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.url.dir.internal.ResourceLocator;

public class ResourceWriter
implements ResourceLocator {
    private final File m_base;
    private final FilenameFilter m_filter;

    public ResourceWriter(FilenameFilter filter, File base) {
        this.m_filter = filter;
        this.m_base = base;
    }

    public ResourceWriter(File base) {
        this.m_filter = new FilenameFilter(){

            public boolean accept(File file, String s) {
                return true;
            }
        };
        this.m_base = base;
    }

    public void write(JarOutputStream target) throws IOException {
        NullArgumentException.validateNotNull(target, "target");
        if (this.m_base == null) {
            throw new IllegalArgumentException("-- has not been found!");
        }
        this.findAndWriteResources(target, this.m_base);
    }

    private void findAndWriteResources(JarOutputStream target, File dir) throws IOException {
        if (dir != null && dir.canRead() && dir.isDirectory()) {
            for (File f : dir.listFiles(this.m_filter)) {
                if (f.isDirectory()) {
                    this.findAndWriteResources(target, f);
                    continue;
                }
                if (f.isHidden()) continue;
                this.writeToTarget(target, f);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToTarget(JarOutputStream target, File f) throws IOException {
        String name = f.getCanonicalPath().substring(this.m_base.getCanonicalPath().length() + 1).replace(File.separatorChar, '/');
        if (name.equals("META-INF/MANIFEST.MF")) {
            throw new RuntimeException("You have specified a " + name + " in your probe bundle. Please make sure that you don't have it in your project's target folder. Otherwise it would lead to false assumptions and unexpected results.");
        }
        FileInputStream fis = new FileInputStream(f);
        try {
            this.write(name, fis, target);
        }
        finally {
            fis.close();
        }
    }

    void write(String name, InputStream fileIn, JarOutputStream target) throws IOException {
        target.putNextEntry(new JarEntry(name));
        StreamUtils.copyStream(fileIn, target, false);
    }
}

