/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.url.war.internal;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.ops4j.pax.url.commons.handler.ConnectionFactory;
import org.ops4j.pax.url.commons.handler.HandlerActivator;
import org.ops4j.pax.url.war.internal.Configuration;
import org.ops4j.pax.url.war.internal.ConfigurationImpl;
import org.ops4j.pax.url.war.internal.WarConnection;
import org.ops4j.pax.url.war.internal.WarReferenceConnection;
import org.ops4j.pax.url.war.internal.WebBundleConnection;
import org.ops4j.util.property.PropertyResolver;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Activator
extends HandlerActivator<Configuration> {
    public Activator() {
        super(new String[]{"war", "war-i", "warref", "webbundle"}, "org.ops4j.pax.url.war", new ConnectionFactory<Configuration>(){

            @Override
            public URLConnection createConection(BundleContext bundleContext, URL url, Configuration config) throws MalformedURLException {
                String protocol = url.getProtocol();
                if ("war".equals(protocol)) {
                    return new WarConnection(url, config);
                }
                if ("webbundle".equals(protocol)) {
                    return new WebBundleConnection(url, config);
                }
                if ("war-i".equals(protocol) || "warref".equals(protocol)) {
                    return new WarReferenceConnection(url, config);
                }
                throw new MalformedURLException("Unsupported protocol: " + protocol);
            }

            @Override
            public Configuration createConfiguration(PropertyResolver propertyResolver) {
                return new ConfigurationImpl(propertyResolver);
            }
        });
    }
}

