/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.maven.repository.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import shaded.org.apache.maven.model.DependencyManagement;
import shaded.org.apache.maven.model.DistributionManagement;
import shaded.org.apache.maven.model.License;
import shaded.org.apache.maven.model.Model;
import shaded.org.apache.maven.model.Prerequisites;
import shaded.org.apache.maven.model.Relocation;
import shaded.org.apache.maven.model.Repository;
import shaded.org.apache.maven.model.building.DefaultModelBuilderFactory;
import shaded.org.apache.maven.model.building.DefaultModelBuildingRequest;
import shaded.org.apache.maven.model.building.FileModelSource;
import shaded.org.apache.maven.model.building.ModelBuilder;
import shaded.org.apache.maven.model.building.ModelBuildingException;
import shaded.org.apache.maven.model.building.ModelProblem;
import shaded.org.apache.maven.model.resolution.UnresolvableModelException;
import shaded.org.apache.maven.repository.internal.ArtifactDescriptorUtils;
import shaded.org.apache.maven.repository.internal.DefaultModelCache;
import shaded.org.apache.maven.repository.internal.DefaultModelResolver;
import shaded.org.apache.maven.repository.internal.RelocatedArtifact;
import shaded.org.codehaus.plexus.component.annotations.Component;
import shaded.org.codehaus.plexus.component.annotations.Requirement;
import shaded.org.eclipse.aether.RepositoryEvent;
import shaded.org.eclipse.aether.RepositoryException;
import shaded.org.eclipse.aether.RepositorySystemSession;
import shaded.org.eclipse.aether.RequestTrace;
import shaded.org.eclipse.aether.artifact.Artifact;
import shaded.org.eclipse.aether.artifact.ArtifactType;
import shaded.org.eclipse.aether.artifact.ArtifactTypeRegistry;
import shaded.org.eclipse.aether.artifact.DefaultArtifact;
import shaded.org.eclipse.aether.artifact.DefaultArtifactType;
import shaded.org.eclipse.aether.graph.Dependency;
import shaded.org.eclipse.aether.graph.Exclusion;
import shaded.org.eclipse.aether.impl.ArtifactDescriptorReader;
import shaded.org.eclipse.aether.impl.ArtifactResolver;
import shaded.org.eclipse.aether.impl.RemoteRepositoryManager;
import shaded.org.eclipse.aether.impl.RepositoryEventDispatcher;
import shaded.org.eclipse.aether.impl.VersionResolver;
import shaded.org.eclipse.aether.repository.WorkspaceRepository;
import shaded.org.eclipse.aether.resolution.ArtifactDescriptorException;
import shaded.org.eclipse.aether.resolution.ArtifactDescriptorPolicy;
import shaded.org.eclipse.aether.resolution.ArtifactDescriptorPolicyRequest;
import shaded.org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import shaded.org.eclipse.aether.resolution.ArtifactDescriptorResult;
import shaded.org.eclipse.aether.resolution.ArtifactRequest;
import shaded.org.eclipse.aether.resolution.ArtifactResolutionException;
import shaded.org.eclipse.aether.resolution.ArtifactResult;
import shaded.org.eclipse.aether.resolution.VersionRequest;
import shaded.org.eclipse.aether.resolution.VersionResolutionException;
import shaded.org.eclipse.aether.resolution.VersionResult;
import shaded.org.eclipse.aether.spi.locator.Service;
import shaded.org.eclipse.aether.spi.locator.ServiceLocator;
import shaded.org.eclipse.aether.spi.log.Logger;
import shaded.org.eclipse.aether.spi.log.LoggerFactory;
import shaded.org.eclipse.aether.spi.log.NullLoggerFactory;
import shaded.org.eclipse.aether.transfer.ArtifactNotFoundException;

@Named
@Component(role=ArtifactDescriptorReader.class)
public class DefaultArtifactDescriptorReader
implements ArtifactDescriptorReader,
Service {
    @Requirement(role=LoggerFactory.class)
    private Logger logger = NullLoggerFactory.LOGGER;
    @Requirement
    private RemoteRepositoryManager remoteRepositoryManager;
    @Requirement
    private VersionResolver versionResolver;
    @Requirement
    private ArtifactResolver artifactResolver;
    @Requirement
    private RepositoryEventDispatcher repositoryEventDispatcher;
    @Requirement
    private ModelBuilder modelBuilder;

    public DefaultArtifactDescriptorReader() {
    }

    @Inject
    DefaultArtifactDescriptorReader(RemoteRepositoryManager remoteRepositoryManager, VersionResolver versionResolver, ArtifactResolver artifactResolver, ModelBuilder modelBuilder, RepositoryEventDispatcher repositoryEventDispatcher, LoggerFactory loggerFactory) {
        this.setRemoteRepositoryManager(remoteRepositoryManager);
        this.setVersionResolver(versionResolver);
        this.setArtifactResolver(artifactResolver);
        this.setModelBuilder(modelBuilder);
        this.setLoggerFactory(loggerFactory);
        this.setRepositoryEventDispatcher(repositoryEventDispatcher);
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.setLoggerFactory(locator.getService(LoggerFactory.class));
        this.setRemoteRepositoryManager(locator.getService(RemoteRepositoryManager.class));
        this.setVersionResolver(locator.getService(VersionResolver.class));
        this.setArtifactResolver(locator.getService(ArtifactResolver.class));
        this.setRepositoryEventDispatcher(locator.getService(RepositoryEventDispatcher.class));
        this.modelBuilder = locator.getService(ModelBuilder.class);
        if (this.modelBuilder == null) {
            this.setModelBuilder(new DefaultModelBuilderFactory().newInstance());
        }
    }

    public DefaultArtifactDescriptorReader setLoggerFactory(LoggerFactory loggerFactory) {
        this.logger = NullLoggerFactory.getSafeLogger(loggerFactory, this.getClass());
        return this;
    }

    void setLogger(LoggerFactory loggerFactory) {
        this.setLoggerFactory(loggerFactory);
    }

    public DefaultArtifactDescriptorReader setRemoteRepositoryManager(RemoteRepositoryManager remoteRepositoryManager) {
        if (remoteRepositoryManager == null) {
            throw new IllegalArgumentException("remote repository manager has not been specified");
        }
        this.remoteRepositoryManager = remoteRepositoryManager;
        return this;
    }

    public DefaultArtifactDescriptorReader setVersionResolver(VersionResolver versionResolver) {
        if (versionResolver == null) {
            throw new IllegalArgumentException("version resolver has not been specified");
        }
        this.versionResolver = versionResolver;
        return this;
    }

    public DefaultArtifactDescriptorReader setArtifactResolver(ArtifactResolver artifactResolver) {
        if (artifactResolver == null) {
            throw new IllegalArgumentException("artifact resolver has not been specified");
        }
        this.artifactResolver = artifactResolver;
        return this;
    }

    public DefaultArtifactDescriptorReader setRepositoryEventDispatcher(RepositoryEventDispatcher repositoryEventDispatcher) {
        if (repositoryEventDispatcher == null) {
            throw new IllegalArgumentException("repository event dispatcher has not been specified");
        }
        this.repositoryEventDispatcher = repositoryEventDispatcher;
        return this;
    }

    public DefaultArtifactDescriptorReader setModelBuilder(ModelBuilder modelBuilder) {
        if (modelBuilder == null) {
            throw new IllegalArgumentException("model builder has not been specified");
        }
        this.modelBuilder = modelBuilder;
        return this;
    }

    @Override
    public ArtifactDescriptorResult readArtifactDescriptor(RepositorySystemSession session, ArtifactDescriptorRequest request) throws ArtifactDescriptorException {
        ArtifactDescriptorResult result = new ArtifactDescriptorResult(request);
        Model model = this.loadPom(session, request, result);
        if (model != null) {
            ArtifactTypeRegistry stereotypes = session.getArtifactTypeRegistry();
            for (Repository r : model.getRepositories()) {
                result.addRepository(ArtifactDescriptorUtils.toRemoteRepository(r));
            }
            for (shaded.org.apache.maven.model.Dependency dependency : model.getDependencies()) {
                result.addDependency(this.convert(dependency, stereotypes));
            }
            DependencyManagement mngt = model.getDependencyManagement();
            if (mngt != null) {
                for (shaded.org.apache.maven.model.Dependency dependency : mngt.getDependencies()) {
                    result.addManagedDependency(this.convert(dependency, stereotypes));
                }
            }
            LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
            Prerequisites prerequisites = model.getPrerequisites();
            if (prerequisites != null) {
                properties.put("prerequisites.maven", prerequisites.getMaven());
            }
            List<License> licenses = model.getLicenses();
            properties.put("license.count", licenses.size());
            for (int i = 0; i < licenses.size(); ++i) {
                License license = licenses.get(i);
                properties.put("license." + i + ".name", license.getName());
                properties.put("license." + i + ".url", license.getUrl());
                properties.put("license." + i + ".comments", license.getComments());
                properties.put("license." + i + ".distribution", license.getDistribution());
            }
            result.setProperties(properties);
            this.setArtifactProperties(result, model);
        }
        return result;
    }

    private Model loadPom(RepositorySystemSession session, ArtifactDescriptorRequest request, ArtifactDescriptorResult result) throws ArtifactDescriptorException {
        Model model;
        RequestTrace trace = RequestTrace.newChild(request.getTrace(), request);
        LinkedHashSet<String> visited = new LinkedHashSet<String>();
        Artifact artifact = request.getArtifact();
        while (true) {
            ArtifactResult resolveResult;
            Artifact pomArtifact = ArtifactDescriptorUtils.toPomArtifact(artifact);
            try {
                VersionRequest versionRequest = new VersionRequest(artifact, request.getRepositories(), request.getRequestContext());
                versionRequest.setTrace(trace);
                VersionResult versionResult = this.versionResolver.resolveVersion(session, versionRequest);
                artifact = artifact.setVersion(versionResult.getVersion());
                versionRequest = new VersionRequest(pomArtifact, request.getRepositories(), request.getRequestContext());
                versionRequest.setTrace(trace);
                versionResult = this.versionResolver.resolveVersion(session, versionRequest);
                pomArtifact = pomArtifact.setVersion(versionResult.getVersion());
            }
            catch (VersionResolutionException e) {
                result.addException(e);
                throw new ArtifactDescriptorException(result);
            }
            if (!visited.add(artifact.getGroupId() + ':' + artifact.getArtifactId() + ':' + artifact.getBaseVersion())) {
                RepositoryException exception = new RepositoryException("Artifact relocations form a cycle: " + visited);
                this.invalidDescriptor(session, trace, artifact, exception);
                if ((this.getPolicy(session, artifact, request) & 2) != 0) {
                    return null;
                }
                result.addException(exception);
                throw new ArtifactDescriptorException(result);
            }
            try {
                ArtifactRequest resolveRequest = new ArtifactRequest(pomArtifact, request.getRepositories(), request.getRequestContext());
                resolveRequest.setTrace(trace);
                resolveResult = this.artifactResolver.resolveArtifact(session, resolveRequest);
                pomArtifact = resolveResult.getArtifact();
                result.setRepository(resolveResult.getRepository());
            }
            catch (ArtifactResolutionException e) {
                if (e.getCause() instanceof ArtifactNotFoundException) {
                    this.missingDescriptor(session, trace, artifact, (Exception)e.getCause());
                    if ((this.getPolicy(session, artifact, request) & 1) != 0) {
                        return null;
                    }
                }
                result.addException(e);
                throw new ArtifactDescriptorException(result);
            }
            try {
                DefaultModelBuildingRequest modelRequest = new DefaultModelBuildingRequest();
                modelRequest.setValidationLevel(0);
                modelRequest.setProcessPlugins(false);
                modelRequest.setTwoPhaseBuilding(false);
                modelRequest.setSystemProperties(this.toProperties(session.getUserProperties(), session.getSystemProperties()));
                modelRequest.setModelCache(DefaultModelCache.newInstance(session));
                modelRequest.setModelResolver(new DefaultModelResolver(session, trace.newChild(modelRequest), request.getRequestContext(), this.artifactResolver, this.remoteRepositoryManager, request.getRepositories()));
                if (resolveResult.getRepository() instanceof WorkspaceRepository) {
                    modelRequest.setPomFile(pomArtifact.getFile());
                } else {
                    modelRequest.setModelSource(new FileModelSource(pomArtifact.getFile()));
                }
                model = this.modelBuilder.build(modelRequest).getEffectiveModel();
            }
            catch (ModelBuildingException e) {
                for (ModelProblem problem : e.getProblems()) {
                    if (!(problem.getException() instanceof UnresolvableModelException)) continue;
                    result.addException(problem.getException());
                    throw new ArtifactDescriptorException(result);
                }
                this.invalidDescriptor(session, trace, artifact, e);
                if ((this.getPolicy(session, artifact, request) & 2) != 0) {
                    return null;
                }
                result.addException(e);
                throw new ArtifactDescriptorException(result);
            }
            Relocation relocation = this.getRelocation(model);
            if (relocation == null) break;
            result.addRelocation(artifact);
            artifact = new RelocatedArtifact(artifact, relocation.getGroupId(), relocation.getArtifactId(), relocation.getVersion());
            result.setArtifact(artifact);
        }
        return model;
    }

    private Properties toProperties(Map<String, String> dominant, Map<String, String> recessive) {
        Properties props = new Properties();
        if (recessive != null) {
            props.putAll(recessive);
        }
        if (dominant != null) {
            props.putAll(dominant);
        }
        return props;
    }

    private Relocation getRelocation(Model model) {
        Relocation relocation = null;
        DistributionManagement distMngt = model.getDistributionManagement();
        if (distMngt != null) {
            relocation = distMngt.getRelocation();
        }
        return relocation;
    }

    private void setArtifactProperties(ArtifactDescriptorResult result, Model model) {
        String downloadUrl = null;
        DistributionManagement distMngt = model.getDistributionManagement();
        if (distMngt != null) {
            downloadUrl = distMngt.getDownloadUrl();
        }
        if (downloadUrl != null && downloadUrl.length() > 0) {
            Artifact artifact = result.getArtifact();
            HashMap<String, String> props = new HashMap<String, String>(artifact.getProperties());
            props.put("downloadUrl", downloadUrl);
            result.setArtifact(artifact.setProperties(props));
        }
    }

    private Dependency convert(shaded.org.apache.maven.model.Dependency dependency, ArtifactTypeRegistry stereotypes) {
        ArtifactType stereotype = stereotypes.get(dependency.getType());
        if (stereotype == null) {
            stereotype = new DefaultArtifactType(dependency.getType());
        }
        boolean system = dependency.getSystemPath() != null && dependency.getSystemPath().length() > 0;
        Map<String, String> props = null;
        if (system) {
            props = Collections.singletonMap("localPath", dependency.getSystemPath());
        }
        DefaultArtifact artifact = new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getClassifier(), null, dependency.getVersion(), props, stereotype);
        ArrayList<Exclusion> exclusions = new ArrayList<Exclusion>(dependency.getExclusions().size());
        for (shaded.org.apache.maven.model.Exclusion exclusion : dependency.getExclusions()) {
            exclusions.add(this.convert(exclusion));
        }
        Dependency result = new Dependency((Artifact)artifact, dependency.getScope(), dependency.isOptional(), exclusions);
        return result;
    }

    private Exclusion convert(shaded.org.apache.maven.model.Exclusion exclusion) {
        return new Exclusion(exclusion.getGroupId(), exclusion.getArtifactId(), "*", "*");
    }

    private void missingDescriptor(RepositorySystemSession session, RequestTrace trace, Artifact artifact, Exception exception) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session, RepositoryEvent.EventType.ARTIFACT_DESCRIPTOR_MISSING);
        event.setTrace(trace);
        event.setArtifact(artifact);
        event.setException(exception);
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    private void invalidDescriptor(RepositorySystemSession session, RequestTrace trace, Artifact artifact, Exception exception) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session, RepositoryEvent.EventType.ARTIFACT_DESCRIPTOR_INVALID);
        event.setTrace(trace);
        event.setArtifact(artifact);
        event.setException(exception);
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    private int getPolicy(RepositorySystemSession session, Artifact artifact, ArtifactDescriptorRequest request) {
        ArtifactDescriptorPolicy policy = session.getArtifactDescriptorPolicy();
        if (policy == null) {
            return 0;
        }
        return policy.getPolicy(session, new ArtifactDescriptorPolicyRequest(artifact, request.getRequestContext()));
    }
}

