/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.servlet;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;
import org.ops4j.pax.web.service.spi.model.OsgiContextModel;
import org.ops4j.pax.web.service.spi.servlet.OsgiSessionAttributeListener;

public class OsgiHttpSession
implements HttpSession {
    private final ServletContext osgiContext;
    private final ServletContext context;
    private final HttpSession original;
    private final Map<String, Object> scopedSession;
    private final String key;
    private final OsgiContextModel model;
    private volatile boolean invalid = false;
    private final OsgiSessionAttributeListener osgiSessionsBridge;

    public OsgiHttpSession(HttpSession original, Map<String, Object> scopedSession, String key, OsgiContextModel model, ServletContext osgiContext, ServletContext context, OsgiSessionAttributeListener osgiSessionsBridge) {
        this.original = original;
        this.scopedSession = scopedSession;
        this.key = key;
        this.model = model;
        this.osgiContext = osgiContext;
        this.context = context;
        this.osgiSessionsBridge = osgiSessionsBridge;
    }

    public long getCreationTime() {
        this.checkInvalid();
        return this.original.getCreationTime();
    }

    public String getId() {
        return this.original.getId();
    }

    public long getLastAccessedTime() {
        this.checkInvalid();
        return this.original.getLastAccessedTime();
    }

    public ServletContext getServletContext() {
        this.checkInvalid();
        return this.osgiContext == null ? this.context : this.osgiContext;
    }

    public void setMaxInactiveInterval(int interval) {
        this.checkInvalid();
        this.original.setMaxInactiveInterval(interval);
    }

    public int getMaxInactiveInterval() {
        this.checkInvalid();
        return this.original.getMaxInactiveInterval();
    }

    public HttpSessionContext getSessionContext() {
        this.checkInvalid();
        return this.original.getSessionContext();
    }

    public Object getAttribute(String name) {
        this.checkInvalid();
        return this.scopedSession != null ? this.scopedSession.get(name) : this.original.getAttribute(name);
    }

    public Object getValue(String name) {
        this.checkInvalid();
        return this.scopedSession != null ? this.scopedSession.get(name) : this.original.getValue(name);
    }

    public Enumeration<String> getAttributeNames() {
        this.checkInvalid();
        return this.scopedSession != null ? Collections.enumeration(this.scopedSession.keySet()) : this.original.getAttributeNames();
    }

    public String[] getValueNames() {
        this.checkInvalid();
        return this.scopedSession != null ? this.scopedSession.keySet().toArray(new String[0]) : this.original.getValueNames();
    }

    public void setAttribute(String name, Object value) {
        if (this.scopedSession != null) {
            Object old = value == null ? this.scopedSession.remove(name) : this.scopedSession.put(name, value);
            if (value != old) {
                this.osgiSessionsBridge.callSessionListeners(this, this.model, name, value, old);
            }
        } else {
            this.original.setAttribute(name, value);
        }
    }

    public void putValue(String name, Object value) {
        this.checkInvalid();
        if (this.scopedSession != null) {
            this.setAttribute(name, value);
        } else {
            this.original.putValue(name, value);
        }
    }

    public void removeAttribute(String name) {
        this.checkInvalid();
        if (this.scopedSession != null) {
            this.scopedSession.remove(name);
        } else {
            this.original.removeAttribute(name);
        }
    }

    public void removeValue(String name) {
        this.checkInvalid();
        if (this.scopedSession != null) {
            this.scopedSession.remove(name);
        } else {
            this.original.removeValue(name);
        }
    }

    public void invalidate() {
        this.checkInvalid();
        if (this.scopedSession != null) {
            this.invalid = true;
            this.original.removeAttribute(this.key);
            for (Map.Entry<String, Object> e : this.scopedSession.entrySet()) {
                String key = e.getKey();
                Object value = e.getValue();
                this.osgiSessionsBridge.callSessionListeners(this, this.model, this.key, null, value);
            }
        } else {
            this.original.invalidate();
        }
    }

    public boolean isNew() {
        this.checkInvalid();
        return this.original.isNew();
    }

    private void checkInvalid() {
        if (this.invalid) {
            throw new IllegalStateException("Session is invalid");
        }
    }

    public boolean isInvalid() {
        return this.invalid;
    }
}

