/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: NotSupportedException.java 1506 2007-06-30 15:34:09Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.transaction;
 
/**
 * NotSupportedException exception indicates that the request cannot
 * be executed because the operation is not a supported feature.
 * For example, because nested transactions are not supported, the
 * Transaction Manager throws this exception when a calling thread
 * that is already associated with a transaction attempts to start
 * a new transaction. (A nested transaction occurs when a thread
 * is already associated with one transaction and attempts to
 * start a second transaction.)
 * @author Guillaume Sauthier
 */
public class NotSupportedException extends Exception {

    /**
     * Serial Version UID.
     * TODO Check for interop
     */
    private static final long serialVersionUID = 56870312332816390L;

    /**
     * Creates a new NotSupportedException.
     */
    public NotSupportedException() {
        super();
    }

    /**
     * Creates a new NotSupportedException.
     * @param msg Exception message
     */
    public NotSupportedException(String msg) {
        super(msg);
    }

}
