/**
 * OW2 Specifications
 * Copyright (C) 2007 Bull S.A.S.
 * Contact: easybeans@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: Xid.java 1506 2007-06-30 15:34:09Z sauthieg $
 * --------------------------------------------------------------------------
 */

package javax.transaction.xa;

/**
 * The Xid interface is a Java mapping of the X/Open transaction
 * identifier XID structure. This interface specifies three
 * accessor methods to retrieve a global transaction's format
 * ID, global transaction ID, and branch qualifier. The Xid
 * interface is used by the transaction manager and the resource
 * managers. This interface is not visible to the application
 * programs.
 * @author Guillaume Sauthier
 */
public interface Xid {

    /**
     * Maximum number of bytes returned by getGtrid.
     */
    static final int MAXGTRIDSIZE = 64;

    /**
     * Maximum number of bytes returned by getBqual.
     */
    static final int MAXBQUALSIZE = 64;

    /**
     * Obtain the format identifier part of the XID.
     * @return Format identifier. O means the OSI CCR format.
     */
    int getFormatId();

    /**
     * Obtain the global transaction identifier part of XID
     * as an array of bytes.
     * @return Global transaction identifier.
     */
    byte[] getGlobalTransactionId();

    /**
     * Obtain the transaction branch identifier part of XID
     * as an array of bytes.
     * @return Global transaction identifier.
     */
    byte[] getBranchQualifier();
}
