/*
 * Decompiled with CFR 0.152.
 */
package org.panteleyev.jpackage.util;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.stream.Stream;

public final class DirectoryUtil {
    public static boolean isNestedDirectory(Path parent, Path child) {
        Path absoluteParent = parent.toAbsolutePath();
        Path absoluteChild = child.toAbsolutePath();
        return absoluteChild.startsWith(absoluteParent);
    }

    public static void removeDirectory(Path dir) {
        if (!dir.toFile().exists()) {
            return;
        }
        try (Stream<Path> paths = Files.walk(dir, new FileVisitOption[0]);){
            paths.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private DirectoryUtil() {
    }
}

