/*
 * Decompiled with CFR 0.152.
 */
package play.shaded.ahc.org.asynchttpclient.cookie;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import play.shaded.ahc.io.netty.handler.codec.http.cookie.Cookie;
import play.shaded.ahc.org.asynchttpclient.cookie.CookieStore;
import play.shaded.ahc.org.asynchttpclient.uri.Uri;
import play.shaded.ahc.org.asynchttpclient.util.Assertions;
import play.shaded.ahc.org.asynchttpclient.util.MiscUtils;

public final class ThreadSafeCookieStore
implements CookieStore {
    private final Map<String, Map<CookieKey, StoredCookie>> cookieJar = new ConcurrentHashMap<String, Map<CookieKey, StoredCookie>>();
    private final AtomicInteger counter = new AtomicInteger();

    @Override
    public void add(Uri uri, Cookie cookie) {
        String thisRequestDomain = this.requestDomain(uri);
        String thisRequestPath = this.requestPath(uri);
        this.add(thisRequestDomain, thisRequestPath, cookie);
    }

    @Override
    public List<Cookie> get(Uri uri) {
        return this.get(this.requestDomain(uri), this.requestPath(uri), uri.isSecured());
    }

    @Override
    public List<Cookie> getAll() {
        List<Cookie> result = this.cookieJar.values().stream().flatMap(map -> map.values().stream()).filter(pair -> !this.hasCookieExpired(pair.cookie, pair.createdAt)).map(pair -> pair.cookie).collect(Collectors.toList());
        return result;
    }

    @Override
    public boolean remove(Predicate<Cookie> predicate) {
        boolean[] removed = new boolean[]{false};
        this.cookieJar.forEach((key, value) -> {
            if (!removed[0]) {
                removed[0] = value.entrySet().removeIf(v -> predicate.test(((StoredCookie)v.getValue()).cookie));
            }
        });
        if (removed[0]) {
            this.cookieJar.entrySet().removeIf(entry -> entry.getValue() == null || ((Map)entry.getValue()).isEmpty());
        }
        return removed[0];
    }

    @Override
    public boolean clear() {
        boolean result = !this.cookieJar.isEmpty();
        this.cookieJar.clear();
        return result;
    }

    @Override
    public void evictExpired() {
        this.removeExpired();
    }

    @Override
    public int incrementAndGet() {
        return this.counter.incrementAndGet();
    }

    @Override
    public int decrementAndGet() {
        return this.counter.decrementAndGet();
    }

    @Override
    public int count() {
        return this.counter.get();
    }

    public Map<String, Map<CookieKey, StoredCookie>> getUnderlying() {
        return new HashMap<String, Map<CookieKey, StoredCookie>>(this.cookieJar);
    }

    private String requestDomain(Uri requestUri) {
        return requestUri.getHost().toLowerCase();
    }

    private String requestPath(Uri requestUri) {
        return requestUri.getPath().isEmpty() ? "/" : requestUri.getPath();
    }

    private AbstractMap.SimpleEntry<String, Boolean> cookieDomain(String cookieDomain, String requestDomain) {
        if (cookieDomain != null) {
            String normalizedCookieDomain = cookieDomain.toLowerCase();
            return new AbstractMap.SimpleEntry<String, Boolean>(!cookieDomain.isEmpty() && cookieDomain.charAt(0) == '.' ? normalizedCookieDomain.substring(1) : normalizedCookieDomain, false);
        }
        return new AbstractMap.SimpleEntry<String, Boolean>(requestDomain, true);
    }

    private String cookiePath(String rawCookiePath, String requestPath) {
        if (MiscUtils.isNonEmpty(rawCookiePath) && rawCookiePath.charAt(0) == '/') {
            return rawCookiePath;
        }
        int indexOfLastSlash = requestPath.lastIndexOf(47);
        if (!requestPath.isEmpty() && requestPath.charAt(0) == '/' && indexOfLastSlash > 0) {
            return requestPath.substring(0, indexOfLastSlash);
        }
        return "/";
    }

    private boolean hasCookieExpired(Cookie cookie, long whenCreated) {
        if (cookie.maxAge() == Long.MIN_VALUE) {
            return false;
        }
        if (cookie.maxAge() <= 0L) {
            return true;
        }
        if (whenCreated > 0L) {
            long deltaSecond = (System.currentTimeMillis() - whenCreated) / 1000L;
            return deltaSecond > cookie.maxAge();
        }
        return false;
    }

    private boolean pathsMatch(String cookiePath, String requestPath) {
        return Objects.equals(cookiePath, requestPath) || requestPath.startsWith(cookiePath) && (cookiePath.charAt(cookiePath.length() - 1) == '/' || requestPath.charAt(cookiePath.length()) == '/');
    }

    private void add(String requestDomain, String requestPath, Cookie cookie) {
        AbstractMap.SimpleEntry<String, Boolean> pair = this.cookieDomain(cookie.domain(), requestDomain);
        String keyDomain = pair.getKey();
        boolean hostOnly = pair.getValue();
        String keyPath = this.cookiePath(cookie.path(), requestPath);
        CookieKey key = new CookieKey(cookie.name().toLowerCase(), keyPath);
        if (this.hasCookieExpired(cookie, 0L)) {
            this.cookieJar.getOrDefault(keyDomain, Collections.emptyMap()).remove(key);
        } else {
            Map innerMap = this.cookieJar.computeIfAbsent(keyDomain, domain -> new ConcurrentHashMap());
            innerMap.put(key, new StoredCookie(cookie, hostOnly, cookie.maxAge() != Long.MIN_VALUE));
        }
    }

    private List<Cookie> get(String domain, String path, boolean secure) {
        boolean exactDomainMatch = true;
        String subDomain = domain;
        ArrayList<Cookie> results = null;
        while (MiscUtils.isNonEmpty(subDomain)) {
            List<Cookie> storedCookies = this.getStoredCookies(subDomain, path, secure, exactDomainMatch);
            subDomain = DomainUtils.getSubDomain(subDomain);
            exactDomainMatch = false;
            if (storedCookies.isEmpty()) continue;
            if (results == null) {
                results = new ArrayList<Cookie>(4);
            }
            results.addAll(storedCookies);
        }
        return results == null ? Collections.emptyList() : results;
    }

    private List<Cookie> getStoredCookies(String domain, String path, boolean secure, boolean isExactMatch) {
        Map<CookieKey, StoredCookie> innerMap = this.cookieJar.get(domain);
        if (innerMap == null) {
            return Collections.emptyList();
        }
        return innerMap.entrySet().stream().filter(pair -> {
            CookieKey key = (CookieKey)pair.getKey();
            StoredCookie storedCookie = (StoredCookie)pair.getValue();
            boolean hasCookieExpired = this.hasCookieExpired(storedCookie.cookie, storedCookie.createdAt);
            return !(hasCookieExpired || !isExactMatch && storedCookie.hostOnly || !this.pathsMatch(key.path, path) || !secure && storedCookie.cookie.isSecure());
        }).map(v -> ((StoredCookie)v.getValue()).cookie).collect(Collectors.toList());
    }

    private void removeExpired() {
        boolean[] removed = new boolean[]{false};
        this.cookieJar.values().forEach(cookieMap -> {
            removed[0] = removed[0] | cookieMap.entrySet().removeIf(v -> this.hasCookieExpired(((StoredCookie)v.getValue()).cookie, ((StoredCookie)v.getValue()).createdAt));
        });
        if (removed[0]) {
            this.cookieJar.entrySet().removeIf(entry -> entry.getValue() == null || ((Map)entry.getValue()).isEmpty());
        }
    }

    public static final class DomainUtils {
        private static final char DOT = '.';

        public static String getSubDomain(String domain) {
            if (domain == null || domain.isEmpty()) {
                return null;
            }
            int indexOfDot = domain.indexOf(46);
            if (indexOfDot == -1) {
                return null;
            }
            return domain.substring(indexOfDot + 1);
        }

        private DomainUtils() {
        }
    }

    private static class StoredCookie {
        final Cookie cookie;
        final boolean hostOnly;
        final boolean persistent;
        final long createdAt = System.currentTimeMillis();

        StoredCookie(Cookie cookie, boolean hostOnly, boolean persistent) {
            this.cookie = cookie;
            this.hostOnly = hostOnly;
            this.persistent = persistent;
        }

        public String toString() {
            return String.format("%s; hostOnly %s; persistent %s", this.cookie.toString(), this.hostOnly, this.persistent);
        }
    }

    private static class CookieKey
    implements Comparable<CookieKey> {
        final String name;
        final String path;

        CookieKey(String name, String path) {
            this.name = name;
            this.path = path;
        }

        @Override
        public int compareTo(CookieKey o) {
            Assertions.assertNotNull(o, "Parameter can't be null");
            int result = this.name.compareTo(o.name);
            if (result == 0) {
                result = this.path.compareTo(o.path);
            }
            return result;
        }

        public boolean equals(Object obj) {
            return obj instanceof CookieKey && this.compareTo((CookieKey)obj) == 0;
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + this.name.hashCode();
            result = 31 * result + this.path.hashCode();
            return result;
        }

        public String toString() {
            return String.format("%s: %s", this.name, this.path);
        }
    }
}

