/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.adapter;

import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Parameter;
import org.restlet.data.ServerInfo;
import org.restlet.data.Status;
import org.restlet.engine.adapter.ServerCall;
import org.restlet.util.Series;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpResponse
extends Response {
    private volatile ServerCall httpCall;
    private volatile boolean serverAdded = false;

    public static void addHeader(Response response, String headerName, String headerValue) {
        if (response instanceof HttpResponse) {
            ((HttpResponse)response).getHeaders().add(headerName, headerValue);
        }
    }

    public HttpResponse(ServerCall httpCall, Request request) {
        super(request);
        this.httpCall = httpCall;
        this.setStatus(Status.SUCCESS_OK);
    }

    public Series<Parameter> getHeaders() {
        return (Series)this.getAttributes().get("org.restlet.http.headers");
    }

    public ServerCall getHttpCall() {
        return this.httpCall;
    }

    @Override
    public ServerInfo getServerInfo() {
        ServerInfo result = super.getServerInfo();
        if (!this.serverAdded) {
            result.setAddress(this.httpCall.getServerAddress());
            result.setAgent("Restlet-Framework/2.1m1");
            result.setPort(this.httpCall.getServerPort());
            this.serverAdded = true;
        }
        return result;
    }
}

