/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.connector;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.restlet.Client;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.engine.connector.ClientConnectionController;
import org.restlet.engine.connector.Connection;
import org.restlet.engine.connector.ConnectionController;
import org.restlet.engine.connector.ConnectionHelper;
import org.restlet.engine.connector.ConnectionState;
import org.restlet.engine.connector.MessageState;
import org.restlet.engine.io.IoState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClientConnectionHelper
extends ConnectionHelper<Client> {
    private static final String CONNECTOR_LATCH = "org.restlet.engine.connector.latch";

    public ClientConnectionHelper(Client connector) {
        super(connector, true);
    }

    @Override
    protected Connection<Client> createConnection(SocketChannel socketChannel, ConnectionController controller, SocketAddress socketAddress) throws IOException {
        return new Connection<Client>(this, socketChannel, controller, socketAddress);
    }

    @Override
    protected ConnectionController createController() {
        return new ClientConnectionController(this);
    }

    protected SocketFactory createSecureSocketFactory() throws IOException, GeneralSecurityException {
        String certAlgorithm = this.getCertAlgorithm();
        String keystorePath = this.getKeystorePath();
        String keystorePassword = this.getKeystorePassword();
        String keyPassword = this.getKeyPassword();
        String truststoreType = this.getTruststoreType();
        String truststorePath = this.getTruststorePath();
        String truststorePassword = this.getTruststorePassword();
        String secureRandomAlgorithm = this.getSecureRandomAlgorithm();
        String securityProvider = this.getSecurityProvider();
        FileInputStream keystoreInputStream = null;
        if (keystorePath != null && new File(keystorePath).exists()) {
            keystoreInputStream = new FileInputStream(keystorePath);
        }
        KeyStore keystore = null;
        if (keystoreInputStream != null) {
            try {
                keystore = KeyStore.getInstance(this.getKeystoreType());
                keystore.load(keystoreInputStream, keystorePassword == null ? null : keystorePassword.toCharArray());
            }
            catch (IOException ioe) {
                this.getLogger().log(Level.WARNING, "Unable to load the key store", ioe);
                keystore = null;
            }
        }
        KeyManager[] keyManagers = null;
        if (keystore != null && keyPassword != null) {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(certAlgorithm);
            keyManagerFactory.init(keystore, keyPassword.toCharArray());
            keyManagers = keyManagerFactory.getKeyManagers();
        }
        FileInputStream truststoreInputStream = null;
        if (truststorePath != null && new File(truststorePath).exists()) {
            truststoreInputStream = new FileInputStream(truststorePath);
        }
        KeyStore truststore = null;
        if (truststoreType != null && truststoreInputStream != null) {
            try {
                truststore = KeyStore.getInstance(truststoreType);
                truststore.load(truststoreInputStream, truststorePassword == null ? null : truststorePassword.toCharArray());
            }
            catch (IOException ioe) {
                this.getLogger().log(Level.WARNING, "Unable to load the trust store", ioe);
                truststore = null;
            }
        }
        TrustManager[] trustManagers = null;
        if (truststore != null) {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(certAlgorithm);
            trustManagerFactory.init(truststore);
            trustManagers = trustManagerFactory.getTrustManagers();
        }
        SecureRandom secureRandom = secureRandomAlgorithm == null ? null : SecureRandom.getInstance(secureRandomAlgorithm);
        SSLContext context = securityProvider == null ? SSLContext.getInstance(this.getSslProtocol()) : SSLContext.getInstance(this.getSslProtocol(), securityProvider);
        context.init(keyManagers, trustManagers, secureRandom);
        return context.getSocketFactory();
    }

    protected SocketChannel createSocketChannel(boolean secure, InetSocketAddress socketAddress) throws UnknownHostException, IOException {
        return this.createSocketChannel(secure, socketAddress.getHostName(), socketAddress.getPort());
    }

    protected SocketChannel createSocketChannel(boolean secure, String hostDomain, int hostPort) throws UnknownHostException, IOException {
        SocketChannel result = SocketChannel.open();
        result.configureBlocking(false);
        Socket socket = result.socket();
        socket.setKeepAlive(this.isSocketKeepAlive());
        socket.setOOBInline(this.isSocketOobInline());
        socket.setReceiveBufferSize(this.getSocketReceiveBufferSize());
        socket.setReuseAddress(this.isSocketReuseAddress());
        socket.setSoLinger(this.getSocketLingerTimeMs() > 0, this.getSocketLingerTimeMs());
        socket.setSendBufferSize(this.getSocketSendBufferSize());
        socket.setSoTimeout(this.getMaxIoIdleTimeMs());
        socket.setTcpNoDelay(this.isSocketNoDelay());
        socket.setTrafficClass(this.getSocketTrafficClass());
        InetSocketAddress address = new InetSocketAddress(hostDomain, hostPort);
        result.connect(address);
        return result;
    }

    protected SocketFactory createSocketFactory(boolean secure) {
        SocketFactory result;
        block4: {
            result = null;
            if (secure) {
                try {
                    return this.createSecureSocketFactory();
                }
                catch (IOException ex) {
                    this.getLogger().log(Level.SEVERE, "Could not create secure socket factory: " + ex.getMessage(), ex);
                    break block4;
                }
                catch (GeneralSecurityException ex) {
                    this.getLogger().log(Level.SEVERE, "Could not create secure socket factory: " + ex.getMessage(), ex);
                    break block4;
                }
            }
            result = SocketFactory.getDefault();
        }
        return result;
    }

    protected Connection<Client> getBestConnection(Request request) throws UnknownHostException, IOException {
        Connection result = null;
        int hostConnectionCount = 0;
        int bestCount = 0;
        boolean foundConn = false;
        InetSocketAddress socketAddress = this.getSocketAddress(request);
        if (socketAddress == null) {
            this.getLogger().log(Level.WARNING, "Unable to create a socket address related to the request.");
        } else {
            Iterator iterator = this.getConnections().iterator();
            while (!foundConn && iterator.hasNext()) {
                Connection currConn = iterator.next();
                if (!socketAddress.equals(currConn.getSocketAddress())) continue;
                if (currConn.isPersistent() && currConn.getState().equals((Object)ConnectionState.OPEN) && currConn.getInboundWay().getMessageState().equals((Object)MessageState.IDLE) && currConn.getInboundWay().getIoState().equals((Object)IoState.IDLE) && currConn.getInboundWay().getMessages().isEmpty() && currConn.getOutboundWay().getMessageState().equals((Object)MessageState.IDLE) && currConn.getOutboundWay().getIoState().equals((Object)IoState.IDLE) && currConn.getOutboundWay().getMessages().isEmpty()) {
                    result = currConn;
                    foundConn = true;
                    continue;
                }
                int currCount = currConn.getOutboundWay().getMessages().size();
                if (bestCount > currCount) {
                    bestCount = currCount;
                    result = currConn;
                }
                ++hostConnectionCount;
            }
            if (!(foundConn || this.getMaxTotalConnections() != -1 && this.getConnections().size() >= this.getMaxTotalConnections() || this.getMaxConnectionsPerHost() != -1 && hostConnectionCount >= this.getMaxConnectionsPerHost())) {
                result = this.checkout(this.createSocketChannel(request.isConfidential(), socketAddress), this.getController(), socketAddress);
                this.getConnections().add(result);
            }
        }
        return result;
    }

    public String getCertAlgorithm() {
        return this.getHelpedParameters().getFirstValue("certAlgorithm", "SunX509");
    }

    public int getConnectTimeout() {
        return ((Client)this.getHelped()).getConnectTimeout();
    }

    public String getKeyPassword() {
        return this.getHelpedParameters().getFirstValue("keyPassword", System.getProperty("javax.net.ssl.keyStorePassword"));
    }

    public String getKeystorePassword() {
        return this.getHelpedParameters().getFirstValue("keystorePassword", System.getProperty("javax.net.ssl.keyStorePassword"));
    }

    public String getKeystorePath() {
        return this.getHelpedParameters().getFirstValue("keystorePath", System.getProperty("user.home") + File.separator + ".keystore");
    }

    public String getKeystoreType() {
        return this.getHelpedParameters().getFirstValue("keystoreType", "JKS");
    }

    public String getProxyHost() {
        return this.getHelpedParameters().getFirstValue("proxyHost", System.getProperty("http.proxyHost"));
    }

    public int getProxyPort() {
        String proxyPort = this.getHelpedParameters().getFirstValue("proxyPort", System.getProperty("http.proxyPort"));
        if (proxyPort == null) {
            proxyPort = "3128";
        }
        return Integer.parseInt(proxyPort);
    }

    public String getSecureRandomAlgorithm() {
        return this.getHelpedParameters().getFirstValue("secureRandomAlgorithm", null);
    }

    public String getSecurityProvider() {
        return this.getHelpedParameters().getFirstValue("securityProvider", null);
    }

    protected InetSocketAddress getSocketAddress(Request request) throws UnknownHostException {
        InetSocketAddress result = null;
        String hostDomain = null;
        int hostPort = 0;
        String proxyDomain = this.getProxyHost();
        if (proxyDomain != null && !"".equals(proxyDomain)) {
            hostDomain = proxyDomain;
            try {
                hostPort = this.getProxyPort();
            }
            catch (NumberFormatException nfe) {
                this.getLogger().log(Level.WARNING, "The proxy port must be a valid numeric value.", nfe);
                throw new UnknownHostException();
            }
        } else {
            Reference resourceRef = request.getResourceRef().isRelative() ? request.getResourceRef().getTargetRef() : request.getResourceRef();
            hostDomain = resourceRef.getHostDomain();
            hostPort = resourceRef.getHostPort();
            if (hostPort == -1) {
                hostPort = resourceRef.getSchemeProtocol() != null ? resourceRef.getSchemeProtocol().getDefaultPort() : this.getProtocols().get(0).getDefaultPort();
            }
        }
        if (hostDomain != null && (result = new InetSocketAddress(hostDomain, hostPort)) != null && result.getAddress() == null) {
            throw new UnknownHostException(hostDomain);
        }
        return result;
    }

    public int getSocketLingerTimeMs() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("socketLingerTimeMs", "-1"));
    }

    public int getSocketSendBufferSize() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("socketSendBufferSize", "8192"));
    }

    public int getSocketTrafficClass() {
        return Integer.parseInt(this.getHelpedParameters().getFirstValue("socketTrafficClass", "0"));
    }

    public String getSslProtocol() {
        return this.getHelpedParameters().getFirstValue("sslProtocol", "TLS");
    }

    public String getTruststorePassword() {
        return this.getHelpedParameters().getFirstValue("truststorePassword", System.getProperty("javax.net.ssl.keyStorePassword"));
    }

    public String getTruststorePath() {
        return this.getHelpedParameters().getFirstValue("truststorePath", null);
    }

    public String getTruststoreType() {
        return this.getHelpedParameters().getFirstValue("truststoreType", System.getProperty("javax.net.ssl.trustStoreType"));
    }

    @Override
    public void handle(Request request, Response response) {
        try {
            if (this.isSynchronous(request) && request.isExpectingResponse()) {
                CountDownLatch latch = new CountDownLatch(1);
                request.getAttributes().put(CONNECTOR_LATCH, latch);
                this.getOutboundMessages().add(response);
                this.getController().wakeup();
                if (this.getMaxIoIdleTimeMs() <= 0) {
                    latch.await();
                } else if (!latch.await(this.getMaxIoIdleTimeMs(), TimeUnit.MILLISECONDS)) {
                    response.setStatus(Status.CONNECTOR_ERROR_INTERNAL, "The calling thread timed out while waiting for a response to unblock it.");
                }
            } else {
                this.getOutboundMessages().add(response);
                this.getController().wakeup();
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.INFO, "Error while handling a " + request.getProtocol().getName() + " client request", e);
            response.setStatus(Status.CONNECTOR_ERROR_INTERNAL, e);
        }
    }

    @Override
    public void handleInbound(Response response) {
        if (response != null) {
            if (response.getRequest().getOnResponse() != null) {
                response.getRequest().getOnResponse().handle(response.getRequest(), response);
            }
            if (!response.getStatus().isInformational()) {
                this.unblock(response);
            }
        }
    }

    @Override
    public void handleOutbound(Response response) {
        if (response != null && response.getRequest() != null) {
            try {
                Connection<Client> bestConn = this.getBestConnection(response.getRequest());
                if (bestConn != null) {
                    bestConn.getOutboundWay().getMessages().add(response);
                    this.getConnections().add(bestConn);
                } else {
                    this.getLogger().log(Level.WARNING, "Unable to find a connection to send the request");
                    response.setStatus(Status.CONNECTOR_ERROR_COMMUNICATION, "Unable to find a connection to send the request");
                    this.unblock(response);
                }
            }
            catch (Throwable t) {
                this.getLogger().log(Level.FINE, "An error occured during the communication with the remote server.", t);
                response.setStatus(Status.CONNECTOR_ERROR_COMMUNICATION, t);
                this.unblock(response);
            }
        }
    }

    @Override
    public boolean isControllerDaemon() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("controllerDaemon", "true"));
    }

    @Override
    public boolean isProxying() {
        return this.getProxyHost() != null;
    }

    public boolean isSocketKeepAlive() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("socketKeepAlive", "true"));
    }

    public boolean isSocketNoDelay() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("socketNoDelay", "false"));
    }

    public boolean isSocketOobInline() {
        return Boolean.parseBoolean(this.getHelpedParameters().getFirstValue("socketOobInline", "false"));
    }

    public boolean isSynchronous(Request request) {
        return request.getOnResponse() == null;
    }

    @Override
    public void onError(Status status, Response message) {
        if (message != null) {
            message.setStatus(status);
            this.getInboundMessages().add(message);
            this.getController().wakeup();
        }
    }

    @Override
    public void start() throws Exception {
        this.getLogger().info("Starting the NIO " + this.getProtocols() + " client");
        super.start();
    }

    @Override
    public void stop() throws Exception {
        this.getLogger().info("Stopping the NIO " + this.getProtocols() + " client");
        super.stop();
    }

    private void unblock(Response response) {
        CountDownLatch latch = (CountDownLatch)response.getRequest().getAttributes().get(CONNECTOR_LATCH);
        if (latch != null) {
            latch.countDown();
        }
    }
}

