/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.connector;

import java.io.IOException;
import org.restlet.Message;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Server;
import org.restlet.engine.connector.Connection;
import org.restlet.engine.connector.ConnectionState;
import org.restlet.engine.connector.InboundRequest;
import org.restlet.engine.connector.InboundWay;
import org.restlet.engine.connector.MessageState;
import org.restlet.engine.connector.ServerConnectionHelper;
import org.restlet.engine.header.HeaderUtils;
import org.restlet.engine.io.IoState;
import org.restlet.representation.Representation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerInboundWay
extends InboundWay {
    public ServerInboundWay(Connection<?> connection) {
        super(connection);
    }

    @Override
    protected Message getActualMessage() {
        return this.getMessage().getRequest();
    }

    public Connection<Server> getConnection() {
        return super.getConnection();
    }

    public ServerConnectionHelper getHelper() {
        return (ServerConnectionHelper)super.getHelper();
    }

    @Override
    protected void onReceived() {
        InboundRequest request = (InboundRequest)((Object)this.getMessage().getRequest());
        if (this.getHeaders() != null) {
            request.setHeaders(this.getHeaders());
        }
        if (HeaderUtils.isConnectionClose(this.getHeaders())) {
            this.getConnection().setState(ConnectionState.CLOSING);
        }
        Representation entity = this.createEntity(this.getHeaders());
        this.getMessage().getRequest().setEntity(entity);
        this.getMessage().getServerInfo().setAddress(((Server)this.getConnection().getHelper().getHelped()).getAddress());
        this.getMessage().getServerInfo().setPort(((Server)this.getConnection().getHelper().getHelped()).getPort());
        if (request != null) {
            if (this.getMessage().getRequest().isExpectingResponse()) {
                this.getMessages().add(this.getMessage());
            }
            this.getHelper().getInboundMessages().add(this.getMessage());
        }
        if (!this.getMessage().getRequest().isEntityAvailable()) {
            this.onCompleted(false);
        }
    }

    @Override
    protected void readStartLine() throws IOException {
        String requestMethod = null;
        String requestUri = null;
        String version = null;
        int i = 0;
        int start = 0;
        int size = this.getLineBuilder().length();
        if (size != 0) {
            char next;
            for (i = start; requestMethod == null && i < size; ++i) {
                next = this.getLineBuilder().charAt(i);
                if (!HeaderUtils.isSpace(next)) continue;
                requestMethod = this.getLineBuilder().substring(start, i);
                start = i + 1;
            }
            if (requestMethod == null || i == size) {
                throw new IOException("Unable to parse the request method. End of line reached too early.");
            }
            for (i = start; requestUri == null && i < size; ++i) {
                next = this.getLineBuilder().charAt(i);
                if (!HeaderUtils.isSpace(next)) continue;
                requestUri = this.getLineBuilder().substring(start, i);
                start = i + 1;
            }
            if (i == size) {
                throw new IOException("Unable to parse the request URI. End of line reached too early.");
            }
            if (requestUri == null || requestUri.equals("")) {
                requestUri = "/";
            }
            for (i = start; version == null && i < size; ++i) {
                next = this.getLineBuilder().charAt(i);
            }
            if (i == size) {
                version = this.getLineBuilder().substring(start, i);
                start = i + 1;
            }
            if (version == null) {
                throw new IOException("Unable to parse the protocol version. End of line reached too early.");
            }
            Request request = this.getHelper().createRequest(this.getConnection(), requestMethod, requestUri, version);
            Response response = this.getHelper().createResponse(request);
            this.setMessage(response);
            this.setMessageState(MessageState.HEADERS);
            this.clearLineBuilder();
        }
    }

    @Override
    public void updateState() {
        super.updateState();
        if (this.getIoState() == IoState.IDLE) {
            if (this.getConnection().isPipelining()) {
                this.setIoState(IoState.INTEREST);
            } else if (this.getMessages().isEmpty() && this.getConnection().getOutboundWay().getMessages().isEmpty()) {
                this.setIoState(IoState.INTEREST);
            }
        }
    }
}

