/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.security;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Method;
import org.restlet.security.Authorizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodAuthorizer
extends Authorizer {
    private List<Method> anonymousMethods = new CopyOnWriteArrayList<Method>();
    private List<Method> authenticatedMethods = new CopyOnWriteArrayList<Method>();

    public MethodAuthorizer() {
        this((String)null);
    }

    public MethodAuthorizer(String identifier) {
        super(identifier);
    }

    @Override
    public boolean authorize(Request request, Response response) {
        boolean authorized = false;
        if (request.getClientInfo().isAuthenticated()) {
            for (Method authenticatedMethod : this.getAuthenticatedMethods()) {
                authorized = authorized || request.getMethod().equals(authenticatedMethod);
            }
        } else {
            for (Method authorizedMethod : this.getAnonymousMethods()) {
                authorized = authorized || request.getMethod().equals(authorizedMethod);
            }
        }
        return authorized;
    }

    public List<Method> getAnonymousMethods() {
        return this.anonymousMethods;
    }

    public List<Method> getAuthenticatedMethods() {
        return this.authenticatedMethods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAnonymousMethods(List<Method> anonymousMethods) {
        List<Method> list = this.getAnonymousMethods();
        synchronized (list) {
            if (anonymousMethods != this.getAnonymousMethods()) {
                this.getAnonymousMethods().clear();
                if (anonymousMethods != null) {
                    this.getAnonymousMethods().addAll(anonymousMethods);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAuthenticatedMethods(List<Method> authenticatedMethods) {
        List<Method> list = this.getAuthenticatedMethods();
        synchronized (list) {
            if (authenticatedMethods != this.getAuthenticatedMethods()) {
                this.getAuthenticatedMethods().clear();
                if (authenticatedMethods != null) {
                    this.getAuthenticatedMethods().addAll(authenticatedMethods);
                }
            }
        }
    }
}

