/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import com.google.common.base.Predicate;
import java.io.Serializable;
import javax.faces.component.UIComponent;
import org.richfaces.PanelMenuMode;
import org.richfaces.cdk.annotations.Attribute;
import org.richfaces.cdk.annotations.EventName;
import org.richfaces.component.AbstractActionComponent;
import org.richfaces.component.AbstractPanelMenu;
import org.richfaces.component.AbstractPanelMenuGroup;
import org.richfaces.component.ComponentIterators;
import org.richfaces.component.attribute.AjaxProps;

public abstract class AbstractPanelMenuItem
extends AbstractActionComponent
implements AjaxProps {
    public static final String COMPONENT_TYPE = "org.richfaces.PanelMenuItem";
    public static final String COMPONENT_FAMILY = "org.richfaces.PanelMenuItem";
    private static final ParentItemPredicate PARENT_ITEM_PREDICATE = new ParentItemPredicate();

    protected AbstractPanelMenuItem() {
        this.setRendererType("org.richfaces.PanelMenuItemRenderer");
    }

    public boolean isActiveItem() {
        return this.getName().equals(this.getPanelMenu().getActiveItem());
    }

    public boolean isTopItem() {
        return this.getParentItem() instanceof AbstractPanelMenu;
    }

    public AbstractPanelMenu getPanelMenu() {
        return (AbstractPanelMenu)ComponentIterators.getParent((UIComponent)this, AbstractPanelMenu.class);
    }

    public UIComponent getParentItem() {
        return ComponentIterators.getParent((UIComponent)this, (Predicate)PARENT_ITEM_PREDICATE);
    }

    public String getFamily() {
        return "org.richfaces.PanelMenuItem";
    }

    @Attribute(defaultValue="Boolean.TRUE")
    public abstract Boolean getSelectable();

    @Attribute(defaultValue="Boolean.FALSE", hidden=true)
    public abstract Boolean getUnselectable();

    @Attribute(defaultValue="getPanelMenu().getItemMode()")
    public abstract PanelMenuMode getMode();

    @Attribute(generate=false)
    public String getName() {
        return (String)this.getStateHelper().eval((Serializable)((Object)Properties.name), (Object)this.getId());
    }

    public void setName(String name) {
        this.getStateHelper().put((Serializable)((Object)Properties.name), (Object)name);
    }

    @Attribute
    public abstract String getLabel();

    @Attribute
    public abstract boolean isDisabled();

    @Attribute(generate=false)
    public Object getExecute() {
        Object execute = this.getStateHelper().eval((Serializable)((Object)Properties.execute));
        if (execute == null) {
            execute = "";
        }
        return execute + " " + this.getPanelMenu().getId();
    }

    public void setExecute(Object execute) {
        this.getStateHelper().put((Serializable)((Object)Properties.execute), execute);
    }

    @Attribute(generate=false)
    public String getDisabledClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)Properties.disabledClass), (Object)(this.isTopItem() ? this.getPanelMenu().getTopItemDisabledClass() : this.getPanelMenu().getItemDisabledClass()));
    }

    public void setDisabledClass(String disabledClass) {
        this.getStateHelper().put((Serializable)((Object)Properties.disabledClass), (Object)disabledClass);
    }

    @Attribute(generate=false)
    public String getLeftIcon() {
        return (String)this.getStateHelper().eval((Serializable)((Object)Properties.leftIcon), (Object)(this.isTopItem() ? this.getPanelMenu().getTopItemLeftIcon() : this.getPanelMenu().getItemLeftIcon()));
    }

    public void setLeftIcon(String leftIcon) {
        this.getStateHelper().put((Serializable)((Object)Properties.leftIcon), (Object)leftIcon);
    }

    @Attribute
    public abstract String getLeftIconClass();

    @Attribute(generate=false)
    public String getLeftDisabledIcon() {
        return (String)this.getStateHelper().eval((Serializable)((Object)Properties.leftDisabledIcon), (Object)(this.isTopItem() ? this.getPanelMenu().getTopItemDisabledLeftIcon() : this.getPanelMenu().getItemDisabledLeftIcon()));
    }

    public void setLeftDisabledIcon(String leftDisabledIcon) {
        this.getStateHelper().put((Serializable)((Object)Properties.leftDisabledIcon), (Object)leftDisabledIcon);
    }

    @Attribute(generate=false)
    public String getRightIcon() {
        return (String)this.getStateHelper().eval((Serializable)((Object)Properties.rightIcon), (Object)(this.isTopItem() ? this.getPanelMenu().getTopItemRightIcon() : this.getPanelMenu().getItemRightIcon()));
    }

    public void setRightIcon(String iconRight) {
        this.getStateHelper().put((Serializable)((Object)Properties.rightIcon), (Object)iconRight);
    }

    @Attribute
    public abstract String getRightIconClass();

    @Attribute(generate=false)
    public String getRightDisabledIcon() {
        return (String)this.getStateHelper().eval((Serializable)((Object)Properties.rightDisabledIcon), (Object)(this.isTopItem() ? this.getPanelMenu().getTopItemDisabledRightIcon() : this.getPanelMenu().getItemDisabledRightIcon()));
    }

    public void setRightDisabledIcon(String rightDisabledIcon) {
        this.getStateHelper().put((Serializable)((Object)Properties.rightDisabledIcon), (Object)rightDisabledIcon);
    }

    @Attribute
    public abstract String getStyle();

    @Attribute(generate=false)
    public String getStyleClass() {
        return (String)this.getStateHelper().eval((Serializable)((Object)Properties.styleClass), (Object)(this.isTopItem() ? this.getPanelMenu().getTopItemClass() : this.getPanelMenu().getItemClass()));
    }

    public void setStyleClass(String styleClass) {
        this.getStateHelper().put((Serializable)((Object)Properties.styleClass), (Object)styleClass);
    }

    @Attribute(events={@EventName(value="click")})
    public abstract String getOnclick();

    @Attribute(events={@EventName(value="dblclick")})
    public abstract String getOndblclick();

    @Attribute(events={@EventName(value="mousedown")})
    public abstract String getOnmousedown();

    @Attribute(events={@EventName(value="mousemove")})
    public abstract String getOnmousemove();

    @Attribute(events={@EventName(value="mouseout")})
    public abstract String getOnmouseout();

    @Attribute(events={@EventName(value="mouseover")})
    public abstract String getOnmouseover();

    @Attribute(events={@EventName(value="mouseup")})
    public abstract String getOnmouseup();

    @Attribute(events={@EventName(value="unselect")})
    public abstract String getOnunselect();

    @Attribute(events={@EventName(value="select")})
    public abstract String getOnselect();

    @Attribute(events={@EventName(value="beforeselect")})
    public abstract String getOnbeforeselect();

    @Attribute(generate=false, hidden=true)
    public Object getValue() {
        return this.getStateHelper().eval((Serializable)((Object)Properties.value));
    }

    public void setValue(Object value) {
        this.getStateHelper().put((Serializable)((Object)Properties.value), value);
    }

    private static class ParentItemPredicate
    implements Predicate<UIComponent> {
        private ParentItemPredicate() {
        }

        public boolean apply(UIComponent comp) {
            return comp instanceof AbstractPanelMenuGroup || comp instanceof AbstractPanelMenu;
        }
    }

    static enum Properties {
        leftIcon,
        leftDisabledIcon,
        rightIcon,
        rightDisabledIcon,
        styleClass,
        disabledClass,
        execute,
        name,
        value;

    }
}

