/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import com.google.common.base.Strings;
import java.io.IOException;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;
import javax.el.ELException;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.UpdateModelException;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitHint;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ExceptionQueuedEvent;
import javax.faces.event.ExceptionQueuedEventContext;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.event.PhaseId;
import javax.faces.event.PostValidateEvent;
import javax.faces.event.PreValidateEvent;
import org.richfaces.application.FacesMessages;
import org.richfaces.application.MessageFactory;
import org.richfaces.application.ServiceTracker;
import org.richfaces.cdk.annotations.Attribute;
import org.richfaces.cdk.annotations.EventName;
import org.richfaces.component.AbstractDivPanel;
import org.richfaces.component.AbstractTogglePanelItemInterface;
import org.richfaces.component.AbstractTogglePanelTitledItem;
import org.richfaces.component.MetaComponentEncoder;
import org.richfaces.component.MetaComponentResolver;
import org.richfaces.component.SwitchType;
import org.richfaces.component.TogglePanelVisitCallback;
import org.richfaces.component.TogglePanelVisitException;
import org.richfaces.component.TogglePanelVisitState;
import org.richfaces.component.UIRepeat;
import org.richfaces.component.util.MessageUtil;
import org.richfaces.context.ExtendedVisitContext;
import org.richfaces.context.ExtendedVisitContextMode;
import org.richfaces.context.FullVisitContext;
import org.richfaces.event.ItemChangeEvent;
import org.richfaces.event.ItemChangeListener;
import org.richfaces.event.ItemChangeSource;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.renderkit.MetaComponentRenderer;
import org.richfaces.renderkit.util.RendererUtils;

public abstract class AbstractTogglePanel
extends UIOutput
implements AbstractDivPanel,
ItemChangeSource,
MetaComponentResolver,
MetaComponentEncoder {
    public static final String ACTIVE_ITEM_META_COMPONENT = "activeItem";
    public static final String COMPONENT_TYPE = "org.richfaces.TogglePanel";
    public static final String COMPONENT_FAMILY = "org.richfaces.TogglePanel";
    public static final String META_NAME_FIRST = "@first";
    public static final String META_NAME_PREV = "@prev";
    public static final String META_NAME_NEXT = "@next";
    public static final String META_NAME_LAST = "@last";
    public static final String UPDATE_MESSAGE_ID = "javax.faces.component.UIInput.UPDATE";
    private static final Logger LOG = RichfacesLogger.RENDERKIT.getLogger();
    private static final RendererUtils UTILS = RendererUtils.getInstance();
    private String submittedActiveItem = null;

    protected AbstractTogglePanel() {
        this.setRendererType("org.richfaces.TogglePanelRenderer");
    }

    public static boolean isPanelItemDynamic(UIComponent component) {
        for (UIComponent parent = component.getParent(); parent != null; parent = parent.getParent()) {
            if (parent instanceof AbstractTogglePanel) {
                return false;
            }
            if (!(parent instanceof UIRepeat)) continue;
            return true;
        }
        return false;
    }

    public Object getSubmittedValue() {
        return this.submittedActiveItem;
    }

    public void resetValue() {
        this.setValue(null);
        this.setSubmittedValue(null);
        this.setLocalValueSet(false);
        this.setValid(true);
    }

    public void setSubmittedValue(Object submittedValue) {
        this.submittedActiveItem = String.valueOf(submittedValue);
    }

    public boolean isLocalValueSet() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.localValueSet), (Object)false);
    }

    public void setLocalValueSet(boolean localValueSet) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.localValueSet), (Object)localValueSet);
    }

    public boolean isValid() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.valid), (Object)true);
    }

    public void setValid(boolean valid) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.valid), (Object)valid);
    }

    public boolean isRequired() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.required), (Object)false);
    }

    public void setRequired(boolean required) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.required), (Object)required);
    }

    @Attribute
    public boolean isImmediate() {
        return (Boolean)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.immediate), (Object)false);
    }

    public void setImmediate(boolean immediate) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.immediate), (Object)immediate);
    }

    public void encodeBegin(FacesContext facesContext) throws IOException {
        this.updateActiveName(this.getActiveItem());
        super.encodeBegin(facesContext);
    }

    public String updateActiveName(String activeItemName) {
        String firstItemName;
        boolean valid = false;
        if (!Strings.isNullOrEmpty((String)activeItemName)) {
            valid = this.isValidName(activeItemName);
        }
        if (!valid && (firstItemName = this.getFirstNonDisabledItemName()) != null) {
            this.setActiveItem(firstItemName);
            return firstItemName;
        }
        return activeItemName;
    }

    private Boolean isValidName(final String name) {
        final AtomicReference<Boolean> result = new AtomicReference<Boolean>(Boolean.FALSE);
        this.visitTogglePanelItems(this, new TogglePanelVisitCallback(){

            @Override
            public VisitResult visit(FacesContext facesContext, TogglePanelVisitState visitState) {
                AbstractTogglePanelItemInterface panelItem = visitState.getItem();
                if (name.equals(panelItem.getName())) {
                    if (panelItem instanceof AbstractTogglePanelTitledItem) {
                        AbstractTogglePanelTitledItem titledItem = (AbstractTogglePanelTitledItem)panelItem;
                        result.set(!titledItem.isDisabled());
                    } else {
                        result.set(Boolean.TRUE);
                    }
                    return VisitResult.COMPLETE;
                }
                return VisitResult.ACCEPT;
            }
        });
        return result.get();
    }

    private String getFirstNonDisabledItemName() {
        final AtomicReference<Object> result = new AtomicReference<Object>(null);
        this.visitTogglePanelItems(this, new TogglePanelVisitCallback(){

            @Override
            public VisitResult visit(FacesContext facesContext, TogglePanelVisitState visitState) {
                AbstractTogglePanelItemInterface panelItem = visitState.getItem();
                if (panelItem instanceof AbstractTogglePanelTitledItem) {
                    AbstractTogglePanelTitledItem titledItem = (AbstractTogglePanelTitledItem)panelItem;
                    if (!titledItem.isDisabled()) {
                        result.set(titledItem.getName());
                        return VisitResult.COMPLETE;
                    }
                    return VisitResult.ACCEPT;
                }
                result.set(panelItem.getName());
                return VisitResult.COMPLETE;
            }
        });
        return result.get();
    }

    public void processDecodes(FacesContext facesContext) {
        if (facesContext == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        this.pushComponentToEL(facesContext, null);
        final String activeItem = this.getActiveItemValue();
        EnumSet<VisitHint> hints = EnumSet.of(VisitHint.SKIP_UNRENDERED);
        FullVisitContext visitContext = new FullVisitContext(facesContext, hints);
        this.visitTree((VisitContext)visitContext, new VisitCallback(){

            public VisitResult visit(VisitContext context, UIComponent target) {
                if (AbstractTogglePanel.this == target || target instanceof UIRepeat) {
                    return VisitResult.ACCEPT;
                }
                if (AbstractTogglePanel.this.isActiveItem(target, activeItem) || AbstractTogglePanel.this.getSwitchType() == SwitchType.client) {
                    target.processDecodes(context.getFacesContext());
                }
                return VisitResult.REJECT;
            }
        });
        try {
            this.decode(facesContext);
        }
        catch (RuntimeException e) {
            facesContext.renderResponse();
            throw e;
        }
        finally {
            this.popComponentFromEL(facesContext);
        }
        ItemChangeEvent event = this.createItemChangeEvent(facesContext);
        if (event != null) {
            event.queue();
        }
    }

    public void processValidators(FacesContext facesContext) {
        if (facesContext == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        this.pushComponentToEL(facesContext, null);
        Application app = facesContext.getApplication();
        app.publishEvent(facesContext, PreValidateEvent.class, (Object)this);
        final String activeItem = this.getActiveItemValue();
        EnumSet<VisitHint> hints = EnumSet.of(VisitHint.SKIP_UNRENDERED);
        FullVisitContext visitContext = new FullVisitContext(facesContext, hints);
        this.visitTree((VisitContext)visitContext, new VisitCallback(){

            public VisitResult visit(VisitContext context, UIComponent target) {
                if (AbstractTogglePanel.this == target || target instanceof UIRepeat) {
                    return VisitResult.ACCEPT;
                }
                if (AbstractTogglePanel.this.isActiveItem(target, activeItem) || AbstractTogglePanel.this.getSwitchType() == SwitchType.client) {
                    target.processValidators(context.getFacesContext());
                }
                return VisitResult.REJECT;
            }
        });
        app.publishEvent(facesContext, PostValidateEvent.class, (Object)this);
        this.popComponentFromEL(facesContext);
    }

    public void processUpdates(FacesContext facesContext) {
        if (facesContext == null) {
            throw new NullPointerException();
        }
        if (!this.isRendered()) {
            return;
        }
        this.pushComponentToEL(facesContext, null);
        final String activeItem = this.getActiveItemValue();
        EnumSet<VisitHint> hints = EnumSet.of(VisitHint.SKIP_UNRENDERED);
        FullVisitContext visitContext = new FullVisitContext(facesContext, hints);
        this.visitTree((VisitContext)visitContext, new VisitCallback(){

            public VisitResult visit(VisitContext context, UIComponent target) {
                if (AbstractTogglePanel.this == target || target instanceof UIRepeat) {
                    return VisitResult.ACCEPT;
                }
                if (AbstractTogglePanel.this.isActiveItem(target, activeItem) || AbstractTogglePanel.this.getSwitchType() == SwitchType.client) {
                    target.processUpdates(context.getFacesContext());
                }
                return VisitResult.REJECT;
            }
        });
        this.popComponentFromEL(facesContext);
        if (!this.isValid()) {
            facesContext.renderResponse();
        }
    }

    public void decode(FacesContext facesContext) {
        if (facesContext == null) {
            throw new NullPointerException();
        }
        this.setValid(true);
        super.decode(facesContext);
    }

    public void updateModel(FacesContext facesContext) {
        if (facesContext == null) {
            throw new NullPointerException();
        }
        if (!this.isValid() || !this.isLocalValueSet()) {
            return;
        }
        ValueExpression ve = this.getValueExpression("value");
        if (ve == null) {
            return;
        }
        Throwable caught = null;
        FacesMessage message = null;
        try {
            ve.setValue(facesContext.getELContext(), this.getLocalValue());
            this.setValue(null);
            this.setLocalValueSet(false);
        }
        catch (ELException e) {
            caught = e;
            String messageStr = e.getMessage();
            for (Throwable result = e.getCause(); null != result && result.getClass().isAssignableFrom(ELException.class); result = result.getCause()) {
                messageStr = result.getMessage();
            }
            message = messageStr == null ? ((MessageFactory)ServiceTracker.getService(MessageFactory.class)).createMessage(facesContext, FacesMessage.SEVERITY_ERROR, (Enum)FacesMessages.UIINPUT_UPDATE, new Object[]{MessageUtil.getLabel((FacesContext)facesContext, (UIComponent)this)}) : new FacesMessage(FacesMessage.SEVERITY_ERROR, messageStr, messageStr);
            this.setValid(false);
        }
        catch (Exception e) {
            caught = e;
            this.setValid(false);
        }
        if (caught != null) {
            assert (message != null);
            UpdateModelException toQueue = new UpdateModelException(message, caught);
            ExceptionQueuedEventContext eventContext = new ExceptionQueuedEventContext(facesContext, (Throwable)toQueue, (UIComponent)this, PhaseId.UPDATE_MODEL_VALUES);
            facesContext.getApplication().publishEvent(facesContext, ExceptionQueuedEvent.class, (Object)eventContext);
        }
    }

    private ItemChangeEvent createItemChangeEvent(FacesContext facesContext) {
        if (facesContext == null) {
            throw new NullPointerException();
        }
        String activeItem = this.getSubmittedActiveItem();
        if (activeItem == null) {
            return null;
        }
        String previous = (String)this.getValue();
        if (previous == null || !previous.equalsIgnoreCase(activeItem)) {
            UIComponent prevComp = null;
            UIComponent actvComp = null;
            if (previous != null) {
                try {
                    prevComp = (UIComponent)this.getItem(previous);
                }
                catch (TogglePanelVisitException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((CharSequence)"Cannot include dynamic TogglePanelComponents in itemChangeEvents");
                    }
                    prevComp = null;
                }
            }
            if (activeItem != null) {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((CharSequence)"Cannot include dynamic TogglePanelComponents in itemChangeEvents");
                    }
                    actvComp = (UIComponent)this.getItem(activeItem);
                }
                catch (TogglePanelVisitException e) {
                    actvComp = null;
                }
            }
            return new ItemChangeEvent((UIComponent)this, previous, prevComp, activeItem, actvComp);
        }
        return null;
    }

    public void queueEvent(FacesEvent event) {
        if (event instanceof ItemChangeEvent && event.getComponent() == this) {
            this.setEventPhase((ItemChangeEvent)event);
        }
        super.queueEvent(event);
    }

    protected void setEventPhase(ItemChangeEvent event) {
        if (this.isImmediate() || event.getNewItem() != null && RendererUtils.getInstance().isBooleanAttribute(event.getNewItem(), "immediate")) {
            event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
        } else {
            event.setPhaseId(PhaseId.UPDATE_MODEL_VALUES);
        }
    }

    protected void setEventPhase(FacesEvent event) {
        if (this.isImmediate()) {
            event.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
        } else {
            event.setPhaseId(PhaseId.INVOKE_APPLICATION);
        }
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (event instanceof ItemChangeEvent) {
            this.setValue(((ItemChangeEvent)event).getNewItemName());
            this.setSubmittedActiveItem(null);
            if (event.getPhaseId() == PhaseId.UPDATE_MODEL_VALUES) {
                try {
                    this.updateModel(facesContext);
                }
                catch (RuntimeException e) {
                    facesContext.renderResponse();
                    throw e;
                }
            } else {
                facesContext.renderResponse();
            }
        }
        super.broadcast(event);
    }

    public String getFamily() {
        return "org.richfaces.TogglePanel";
    }

    public boolean getRendersChildren() {
        return true;
    }

    private String getActiveItemValue() {
        String value = this.getActiveItem();
        if (value == null) {
            value = this.getSubmittedActiveItem();
        }
        return value;
    }

    protected boolean isActiveItem(UIComponent kid) {
        return this.isActiveItem(kid, this.getActiveItemValue());
    }

    protected boolean isActiveItem(UIComponent kid, String value) {
        if (kid == null || !(kid instanceof AbstractTogglePanelItemInterface)) {
            return false;
        }
        return this.isActiveItem((AbstractTogglePanelItemInterface)kid, value);
    }

    protected boolean isActiveItem(AbstractTogglePanelItemInterface item, String value) {
        if (item == null || value == null) {
            return false;
        }
        return item.getName().equals(value);
    }

    public TogglePanelVisitState visitTogglePanelItems(AbstractTogglePanel panel, final TogglePanelVisitCallback callback) {
        FacesContext facesContext = this.getFacesContext();
        EnumSet<VisitHint> hints = EnumSet.of(VisitHint.SKIP_UNRENDERED);
        final TogglePanelVisitState visitState = new TogglePanelVisitState();
        FullVisitContext visitContext = new FullVisitContext(facesContext, hints);
        panel.visitTree((VisitContext)visitContext, new VisitCallback(){

            public VisitResult visit(VisitContext context, UIComponent target) {
                if (target instanceof AbstractTogglePanelItemInterface) {
                    AbstractTogglePanelItemInterface item = (AbstractTogglePanelItemInterface)target;
                    visitState.setState(item.getName(), item);
                    if (callback.visit(context.getFacesContext(), visitState) == VisitResult.COMPLETE) {
                        visitState.setDynamic(item.isDynamicPanelItem());
                        return VisitResult.COMPLETE;
                    }
                    visitState.increment();
                    visitState.setState(null, null);
                    return VisitResult.ACCEPT;
                }
                if (AbstractTogglePanel.this == target || target instanceof UIRepeat) {
                    return VisitResult.ACCEPT;
                }
                return VisitResult.REJECT;
            }
        });
        return visitState;
    }

    private TogglePanelVisitState getvisitStateByIndex(final int index) {
        TogglePanelVisitState visitState = this.visitTogglePanelItems(this, new TogglePanelVisitCallback(){

            @Override
            public VisitResult visit(FacesContext facesContext, TogglePanelVisitState visitState) {
                if (index == visitState.getCount()) {
                    return VisitResult.COMPLETE;
                }
                return VisitResult.ACCEPT;
            }
        });
        return visitState;
    }

    public TogglePanelVisitState getVisitStateByName(final String name) {
        TogglePanelVisitState visitState = this.visitTogglePanelItems(this, new TogglePanelVisitCallback(){

            @Override
            public VisitResult visit(FacesContext facesContext, TogglePanelVisitState visitState) {
                if (name.equals(visitState.getName())) {
                    return VisitResult.COMPLETE;
                }
                return VisitResult.ACCEPT;
            }
        });
        return visitState;
    }

    public AbstractTogglePanelItemInterface getItemByIndex(int index) {
        TogglePanelVisitState visitState = this.getvisitStateByIndex(index);
        if (visitState.isDynamic()) {
            throw new TogglePanelVisitException("Cannot access a dynamically generated AbstractToggleItemInterface directly. Use the visitor pattern instead.");
        }
        return visitState.getItem();
    }

    public String getNameByIndex(int index) {
        if (!this.isRendered()) {
            return null;
        }
        return this.getvisitStateByIndex(index).getName();
    }

    public int getIndexByName(String name) {
        if (!this.isRendered()) {
            return -1;
        }
        TogglePanelVisitState visitState = this.getVisitStateByName(name);
        if (visitState.getName() != null) {
            return visitState.getCount();
        }
        return -1;
    }

    public int getItemCount() {
        if (!this.isRendered()) {
            return 0;
        }
        TogglePanelVisitState visitState = this.visitTogglePanelItems(this, new TogglePanelVisitCallback(){

            @Override
            public VisitResult visit(FacesContext facesContext, TogglePanelVisitState visitState) {
                return VisitResult.ACCEPT;
            }
        });
        return visitState.getCount();
    }

    public AbstractTogglePanelItemInterface getItem(String name) {
        if (META_NAME_FIRST.equals(name)) {
            return this.getFirstItem();
        }
        if (META_NAME_PREV.equals(name)) {
            return this.getPrevItem();
        }
        if (META_NAME_NEXT.equals(name)) {
            return this.getNextItem();
        }
        if (META_NAME_LAST.equals(name)) {
            return this.getLastItem();
        }
        return this.getItemByIndex(this.getChildIndex(name));
    }

    public AbstractTogglePanelItemInterface getFirstItem() {
        return this.getItemByIndex(0);
    }

    public AbstractTogglePanelItemInterface getPrevItem() {
        return this.getPrevItem(this.getActiveItem());
    }

    public AbstractTogglePanelItemInterface getPrevItem(String name) {
        return this.getItemByIndex(this.getIndexByName(name) - 1);
    }

    public AbstractTogglePanelItemInterface getNextItem() {
        return this.getNextItem(this.getActiveItem());
    }

    public AbstractTogglePanelItemInterface getNextItem(String name) {
        return this.getItemByIndex(this.getIndexByName(name) + 1);
    }

    public AbstractTogglePanelItemInterface getLastItem() {
        return this.getItemByIndex(this.getItemCount());
    }

    @Deprecated
    public int getChildIndex(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name is required parameter.");
        }
        return this.getIndexByName(name);
    }

    public String getSubmittedActiveItem() {
        return this.submittedActiveItem;
    }

    public void setSubmittedActiveItem(String submittedActiveItem) {
        this.submittedActiveItem = submittedActiveItem;
    }

    @Attribute(hidden=true)
    public void setValue(Object value) {
        super.setValue(value);
        this.setLocalValueSet(true);
    }

    @Attribute
    public String getActiveItem() {
        return (String)this.getValue();
    }

    public void setActiveItem(String value) {
        this.setValue(value);
    }

    public void setValueExpression(String name, ValueExpression binding) {
        if (ACTIVE_ITEM_META_COMPONENT.equals(name)) {
            super.setValueExpression("value", binding);
        } else {
            super.setValueExpression(name, binding);
        }
    }

    @Attribute(generate=false)
    public SwitchType getSwitchType() {
        SwitchType switchType = (SwitchType)this.getStateHelper().eval((Serializable)((Object)PropertyKeys.switchType));
        if (switchType == null) {
            switchType = SwitchType.DEFAULT;
        }
        return switchType;
    }

    public void setSwitchType(SwitchType switchType) {
        this.getStateHelper().put((Serializable)((Object)PropertyKeys.switchType), (Object)switchType);
    }

    @Attribute(hidden=true)
    public abstract boolean isLimitRender();

    @Attribute
    public abstract boolean isCycledSwitching();

    @Attribute(hidden=true)
    public abstract Object getData();

    @Attribute(hidden=true)
    public abstract String getStatus();

    @Attribute(hidden=true)
    public abstract Object getExecute();

    @Attribute(hidden=true)
    public abstract Object getRender();

    @Attribute
    public abstract MethodExpression getItemChangeListener();

    @Attribute(events={@EventName(value="itemchange")})
    public abstract String getOnitemchange();

    @Attribute(events={@EventName(value="beforeitemchange")})
    public abstract String getOnbeforeitemchange();

    public void addItemChangeListener(ItemChangeListener listener) {
        this.addFacesListener((FacesListener)listener);
    }

    public ItemChangeListener[] getItemChangeListeners() {
        return (ItemChangeListener[])this.getFacesListeners(ItemChangeListener.class);
    }

    public void removeItemChangeListener(ItemChangeListener listener) {
        this.removeFacesListener((FacesListener)listener);
    }

    public String resolveClientId(FacesContext facesContext, UIComponent contextComponent, String metaComponentId) {
        if (ACTIVE_ITEM_META_COMPONENT.equals(metaComponentId)) {
            return this.getClientId(facesContext) + '@' + metaComponentId;
        }
        return null;
    }

    public String substituteUnresolvedClientId(FacesContext facesContext, UIComponent contextComponent, String metaComponentId) {
        return null;
    }

    public void encodeMetaComponent(FacesContext facesContext, String metaComponentId) throws IOException {
        ((MetaComponentRenderer)this.getRenderer(facesContext)).encodeMetaComponent(facesContext, (UIComponent)this, metaComponentId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean visitTree(VisitContext context, VisitCallback callback) {
        block10: {
            if (!this.isVisitable(context)) {
                return false;
            }
            FacesContext facesContext = context.getFacesContext();
            this.pushComponentToEL(facesContext, null);
            try {
                ExtendedVisitContext extendedVisitContext;
                VisitResult result = context.invokeVisitCallback((UIComponent)this, callback);
                if (result == VisitResult.COMPLETE) {
                    boolean bl = true;
                    return bl;
                }
                if (result == VisitResult.ACCEPT && context instanceof ExtendedVisitContext && (extendedVisitContext = (ExtendedVisitContext)context).getVisitMode() == ExtendedVisitContextMode.RENDER && (result = extendedVisitContext.invokeMetaComponentVisitCallback((UIComponent)this, callback, ACTIVE_ITEM_META_COMPONENT)) == VisitResult.COMPLETE) {
                    boolean bl = true;
                    return bl;
                }
                if (result != VisitResult.ACCEPT) break block10;
                Iterator kids = this.getFacetsAndChildren();
                while (kids.hasNext()) {
                    boolean done = ((UIComponent)kids.next()).visitTree(context, callback);
                    if (!done) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                this.popComponentFromEL(facesContext);
            }
        }
        return false;
    }

    private static enum PropertyKeys {
        localValueSet,
        required,
        valid,
        immediate,
        switchType;

    }
}

