/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.javascript.JSObject;
import org.richfaces.component.AbstractAccordionItem;
import org.richfaces.component.AbstractTogglePanelTitledItem;
import org.richfaces.renderkit.RenderKitUtils;
import org.richfaces.renderkit.html.AccordionItemHeaderRenderer;
import org.richfaces.renderkit.html.TableIconsRendererHelper;
import org.richfaces.renderkit.html.TogglePanelItemRenderer;

@ResourceDependencies(value={@ResourceDependency(library="org.richfaces", name="ajax.reslib"), @ResourceDependency(library="org.richfaces", name="base-component.reslib"), @ResourceDependency(name="richfaces-event.js"), @ResourceDependency(library="org.richfaces", name="togglePanelItem.js"), @ResourceDependency(library="org.richfaces", name="accordionItem.js")})
public class AccordionItemRenderer
extends TogglePanelItemRenderer {
    private static final RenderKitUtils.Attributes HEADER_ATTRIBUTES = RenderKitUtils.attributes().generic("style", "headerStyle", new String[0]).generic("onclick", "onheaderclick", new String[]{"headerclick"}).generic("ondblclick", "onheaderdblclick", new String[]{"headerdblclick"}).generic("onmousedown", "onheadermousedown", new String[]{"headermousedown"}).generic("onmousemove", "onheadermousemove", new String[]{"headermousemove"}).generic("onmouseup", "onheadermouseup", new String[]{"headermouseup"});
    private final TableIconsRendererHelper<AbstractAccordionItem> headerRenderer = new AccordionItemHeaderRenderer();

    public AccordionItemRenderer() {
        super(false);
    }

    @Override
    protected void doEncodeBegin(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        this.doEncodeItemBegin(writer, context, component);
    }

    @Override
    protected void doEncodeItemBegin(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        super.doEncodeItemBegin(writer, context, component);
        this.encodeHeader(context, (AbstractAccordionItem)component);
        this.encodeContentBegin(context, component);
    }

    @Override
    protected String getStyleClass(UIComponent component) {
        return this.concatClasses(new Object[]{"rf-ac-itm", AccordionItemRenderer.attributeAsString(component, "styleClass")});
    }

    @Override
    protected void doEncodeChildren(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        AbstractAccordionItem item = (AbstractAccordionItem)component;
        if (!item.isDisabled()) {
            super.doEncodeChildren(writer, context, (UIComponent)item);
        }
    }

    @Override
    protected void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        this.doEncodeItemEnd(writer, context, component);
    }

    @Override
    protected void doEncodeItemEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        this.encodeContentEnd(writer, component);
        super.doEncodeItemEnd(writer, context, component);
    }

    private void encodeContentBegin(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", component);
        writer.writeAttribute("class", (Object)this.concatClasses(new Object[]{"rf-ac-itm-cnt", AccordionItemRenderer.attributeAsString(component, "contentClass")}), null);
        writer.writeAttribute("id", (Object)(component.getClientId(context) + ":content"), null);
        AbstractTogglePanelTitledItem item = (AbstractTogglePanelTitledItem)component;
        if (!item.isActive() || item.isDisabled()) {
            writer.writeAttribute("style", (Object)"display: none", null);
        }
    }

    private void encodeContentEnd(ResponseWriter writer, UIComponent component) throws IOException {
        writer.endElement("div");
    }

    private void encodeHeader(FacesContext context, AbstractAccordionItem component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", (UIComponent)component);
        String stateCssClass = "rf-ac-itm-hdr-" + (component.isDisabled() ? "dis" : (component.isActive() ? "act" : "inact"));
        writer.writeAttribute("class", (Object)this.concatClasses(new Object[]{"rf-ac-itm-hdr", stateCssClass, AccordionItemRenderer.attributeAsString((UIComponent)component, "headerClass")}), null);
        writer.writeAttribute("id", (Object)(component.getClientId(context) + ":header"), null);
        RenderKitUtils.renderPassThroughAttributes((FacesContext)context, (UIComponent)component, (Collection)HEADER_ATTRIBUTES);
        this.headerRenderer.encodeHeader(writer, context, component);
        writer.endElement("div");
    }

    @Override
    protected JSObject getScriptObject(FacesContext context, UIComponent component) {
        return new JSObject("RichFaces.ui.AccordionItem", new Object[]{component.getClientId(context), this.getScriptObjectOptions(context, component)});
    }

    @Override
    protected Map<String, Object> getScriptObjectOptions(FacesContext context, UIComponent component) {
        Map<String, Object> res = super.getScriptObjectOptions(context, component);
        res.put("disabled", ((AbstractTogglePanelTitledItem)component).isDisabled());
        return res;
    }

    @Override
    protected Class<? extends UIComponent> getComponentClass() {
        return AbstractAccordionItem.class;
    }
}

