/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.model.mistralai.autoconfigure;

import org.springframework.ai.mistralai.ocr.MistralOcrApi;
import org.springframework.ai.model.mistralai.autoconfigure.MistralAiCommonProperties;
import org.springframework.ai.model.mistralai.autoconfigure.MistralAiOcrProperties;
import org.springframework.ai.retry.autoconfigure.SpringAiRetryAutoConfiguration;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.client.RestClientAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClient;

@AutoConfiguration(after={RestClientAutoConfiguration.class, SpringAiRetryAutoConfiguration.class})
@ConditionalOnClass(value={MistralOcrApi.class})
@ConditionalOnProperty(name={"spring.ai.model.ocr"}, havingValue="mistral", matchIfMissing=true)
@EnableConfigurationProperties(value={MistralAiCommonProperties.class, MistralAiOcrProperties.class})
public class MistralAiOcrAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public MistralOcrApi mistralOcrApi(MistralAiCommonProperties commonProperties, MistralAiOcrProperties ocrProperties, ObjectProvider<RestClient.Builder> restClientBuilderProvider, ResponseErrorHandler responseErrorHandler) {
        String apiKey = ocrProperties.getApiKey();
        String baseUrl = ocrProperties.getBaseUrl();
        String resolvedApiKey = StringUtils.hasText((String)apiKey) ? apiKey : commonProperties.getApiKey();
        String resolvedBaseUrl = StringUtils.hasText((String)baseUrl) ? baseUrl : commonProperties.getBaseUrl();
        Assert.hasText((String)resolvedApiKey, (String)"Mistral API key must be set");
        Assert.hasText((String)resolvedBaseUrl, (String)"Mistral base URL must be set");
        return new MistralOcrApi(resolvedBaseUrl, resolvedApiKey, (RestClient.Builder)restClientBuilderProvider.getIfAvailable(RestClient::builder), responseErrorHandler);
    }
}

