/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.client.advisor;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.modelcontextprotocol.json.TypeRef;
import io.modelcontextprotocol.json.jackson.JacksonMcpJsonMapper;
import io.modelcontextprotocol.json.schema.JsonSchemaValidator;
import io.modelcontextprotocol.json.schema.jackson.DefaultJsonSchemaValidator;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.client.ChatClientRequest;
import org.springframework.ai.chat.client.ChatClientResponse;
import org.springframework.ai.chat.client.advisor.api.CallAdvisor;
import org.springframework.ai.chat.client.advisor.api.CallAdvisorChain;
import org.springframework.ai.chat.client.advisor.api.StreamAdvisor;
import org.springframework.ai.chat.client.advisor.api.StreamAdvisorChain;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.ai.util.json.JsonParser;
import org.springframework.ai.util.json.schema.JsonSchemaGenerator;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;

public final class StructuredOutputValidationAdvisor
implements CallAdvisor,
StreamAdvisor {
    private static final Logger logger = LoggerFactory.getLogger(StructuredOutputValidationAdvisor.class);
    private static final TypeRef<HashMap<String, Object>> MAP_TYPE_REF = new TypeRef<HashMap<String, Object>>(){};
    private final int advisorOrder;
    private final Map<String, Object> jsonSchema;
    private final DefaultJsonSchemaValidator jsonvalidator;
    private final int maxRepeatAttempts;

    private StructuredOutputValidationAdvisor(int advisorOrder, Type outputType, int maxRepeatAttempts, ObjectMapper objectMapper) {
        Assert.notNull((Object)advisorOrder, (String)"advisorOrder must not be null");
        Assert.notNull((Object)outputType, (String)"outputType must not be null");
        Assert.isTrue((advisorOrder > Integer.MIN_VALUE && advisorOrder < Integer.MAX_VALUE ? 1 : 0) != 0, (String)"advisorOrder must be between HIGHEST_PRECEDENCE and LOWEST_PRECEDENCE");
        Assert.isTrue((maxRepeatAttempts >= 0 ? 1 : 0) != 0, (String)"repeatAttempts must be greater than or equal to 0");
        Assert.notNull((Object)objectMapper, (String)"objectMapper must not be null");
        this.advisorOrder = advisorOrder;
        this.jsonvalidator = new DefaultJsonSchemaValidator(objectMapper);
        String jsonSchemaText = JsonSchemaGenerator.generateForType((Type)outputType, (JsonSchemaGenerator.SchemaOption[])new JsonSchemaGenerator.SchemaOption[0]);
        logger.info("Generated JSON Schema:\n" + jsonSchemaText);
        JacksonMcpJsonMapper jsonMapper = new JacksonMcpJsonMapper(JsonParser.getObjectMapper());
        try {
            this.jsonSchema = (Map)jsonMapper.readValue(jsonSchemaText, MAP_TYPE_REF);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to parse JSON schema", e);
        }
        this.maxRepeatAttempts = maxRepeatAttempts;
    }

    @Override
    public String getName() {
        return "Structured Output Validation Advisor";
    }

    public int getOrder() {
        return this.advisorOrder;
    }

    @Override
    public ChatClientResponse adviseCall(ChatClientRequest chatClientRequest, CallAdvisorChain callAdvisorChain) {
        Assert.notNull((Object)callAdvisorChain, (String)"callAdvisorChain must not be null");
        Assert.notNull((Object)chatClientRequest, (String)"chatClientRequest must not be null");
        ChatClientResponse chatClientResponse = null;
        int repeatCounter = 0;
        boolean isValidationSuccess = true;
        ChatClientRequest processedChatClientRequest = chatClientRequest;
        do {
            JsonSchemaValidator.ValidationResponse validationResponse;
            ++repeatCounter;
            chatClientResponse = callAdvisorChain.copy(this).nextCall(processedChatClientRequest);
            if (chatClientResponse.chatResponse() != null && chatClientResponse.chatResponse().hasToolCalls() || (isValidationSuccess = (validationResponse = this.validateOutputSchema(chatClientResponse)).valid())) continue;
            logger.warn("JSON validation failed: " + String.valueOf(validationResponse));
            String validationErrorMessage = "Output JSON validation failed because of: " + validationResponse.errorMessage();
            Prompt augmentedPrompt = chatClientRequest.prompt().augmentUserMessage(userMessage -> userMessage.mutate().text(userMessage.getText() + System.lineSeparator() + validationErrorMessage).build());
            processedChatClientRequest = chatClientRequest.mutate().prompt(augmentedPrompt).build();
        } while (!isValidationSuccess && repeatCounter <= this.maxRepeatAttempts);
        return chatClientResponse;
    }

    private JsonSchemaValidator.ValidationResponse validateOutputSchema(ChatClientResponse chatClientResponse) {
        if (chatClientResponse.chatResponse() == null || chatClientResponse.chatResponse().getResult() == null || chatClientResponse.chatResponse().getResult().getOutput() == null || chatClientResponse.chatResponse().getResult().getOutput().getText() == null) {
            logger.warn("ChatClientResponse is missing required json output for validation.");
            return JsonSchemaValidator.ValidationResponse.asInvalid((String)"Missing required json output for validation.");
        }
        String json = chatClientResponse.chatResponse().getResult().getOutput().getText();
        logger.debug("Validating JSON output against schema. Attempts left: " + this.maxRepeatAttempts);
        return this.jsonvalidator.validate(this.jsonSchema, (Object)json);
    }

    @Override
    public Flux<ChatClientResponse> adviseStream(ChatClientRequest chatClientRequest, StreamAdvisorChain streamAdvisorChain) {
        return Flux.error((Throwable)new UnsupportedOperationException("The Structured Output Validation Advisor does not support streaming."));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private int advisorOrder = 2147481647;
        private Type outputType;
        private int maxRepeatAttempts = 3;
        private ObjectMapper objectMapper = JsonParser.getObjectMapper();

        private Builder() {
        }

        public Builder advisorOrder(int advisorOrder) {
            this.advisorOrder = advisorOrder;
            return this;
        }

        public Builder outputType(Type outputType) {
            this.outputType = outputType;
            return this;
        }

        public <T> Builder outputType(TypeRef<T> outputType) {
            this.outputType = outputType.getType();
            return this;
        }

        public <T> Builder outputType(TypeReference<T> outputType) {
            this.outputType = outputType.getType();
            return this;
        }

        public <T> Builder outputType(ParameterizedTypeReference<T> outputType) {
            this.outputType = outputType.getType();
            return this;
        }

        public Builder maxRepeatAttempts(int repeatAttempts) {
            this.maxRepeatAttempts = repeatAttempts;
            return this;
        }

        public Builder objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        public StructuredOutputValidationAdvisor build() {
            if (this.outputType == null) {
                throw new IllegalArgumentException("outputType must be set");
            }
            return new StructuredOutputValidationAdvisor(this.advisorOrder, this.outputType, this.maxRepeatAttempts, this.objectMapper);
        }
    }
}

