/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.config;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.amqp.core.AcknowledgeMode;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.RabbitAccessor;
import org.springframework.amqp.rabbit.listener.AbstractMessageListenerContainer;
import org.springframework.amqp.rabbit.listener.MessageListenerContainer;
import org.springframework.amqp.rabbit.listener.RabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.listener.RabbitListenerEndpoint;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.util.ErrorHandler;

public abstract class AbstractRabbitListenerContainerFactory<C extends AbstractMessageListenerContainer>
implements RabbitListenerContainerFactory<C> {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private ConnectionFactory connectionFactory;
    private ErrorHandler errorHandler;
    private MessageConverter messageConverter;
    private AcknowledgeMode acknowledgeMode;
    private Boolean channelTransacted;
    private Boolean autoStartup;
    private Integer phase;
    protected final AtomicInteger counter = new AtomicInteger();

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    public void setAcknowledgeMode(AcknowledgeMode acknowledgeMode) {
        this.acknowledgeMode = acknowledgeMode;
    }

    public void setChannelTransacted(Boolean channelTransacted) {
        this.channelTransacted = channelTransacted;
    }

    public void setAutoStartup(Boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    @Override
    public C createListenerContainer(RabbitListenerEndpoint endpoint) {
        C instance = this.createContainerInstance();
        if (this.connectionFactory != null) {
            ((RabbitAccessor)instance).setConnectionFactory(this.connectionFactory);
        }
        if (this.errorHandler != null) {
            ((AbstractMessageListenerContainer)instance).setErrorHandler(this.errorHandler);
        }
        if (this.messageConverter != null) {
            ((AbstractMessageListenerContainer)instance).setMessageConverter(this.messageConverter);
        }
        if (this.acknowledgeMode != null) {
            ((AbstractMessageListenerContainer)instance).setAcknowledgeMode(this.acknowledgeMode);
        }
        if (this.channelTransacted != null) {
            ((RabbitAccessor)instance).setChannelTransacted(this.channelTransacted);
        }
        if (this.autoStartup != null) {
            ((AbstractMessageListenerContainer)instance).setAutoStartup(this.autoStartup);
        }
        if (this.phase != null) {
            ((AbstractMessageListenerContainer)instance).setPhase(this.phase);
        }
        endpoint.setupListenerContainer((MessageListenerContainer)instance);
        this.initializeContainer(instance);
        return instance;
    }

    protected abstract C createContainerInstance();

    protected void initializeContainer(C instance) {
    }
}

